import header from '@blocks/morda/components/header/reducers';
import personReducer from '@blocks/morda/personal_info/reducers.js';
import social from '@blocks/morda/social_info/reducers';
import emails from '@blocks/morda/emails/reducers';
import security from '@blocks/morda/security/reducers';
import domik from '@blocks/morda/components/domik/reducers';
import common from '@blocks/common/reducers';
import captcha from '@components/Captcha/reducers';
import access from '@blocks/morda/access/reducers';
import family from '@blocks/morda/new/family/reducers';
import webauthn from '@blocks/morda/new/auth_block/without_password/Webauthn/reducers';
import addresses from '@blocks/morda/addresses/reducers';
import billing from '@blocks/morda/cards/reducers';
import phoneConfirm from '@blocks/reducers/phoneConfirm';
import changeAvatar from '@blocks/morda/avatar/reducers';
import appPasswords from '@blocks/morda/create_app_passwords/reducers';
import devices from '@blocks/morda/devices/reducers';
import dashboard from '@blocks/morda/dashboard/reducers';
import alice from '@blocks/morda/new/other_settings_block/alice/actions/reducers';
import tracks from '@blocks/reducers/tracks';
import publicId from '@blocks/reducers/publicId';
import form from '@blocks/reducers/form';
import {subs} from '@blocks/Subs/reducer';
import mordaSubscriptionCards from '@blocks/morda/new/subscriptions/reducers';
import am from '@blocks/authv2/reducers/am';
import phones from '@blocks/phones/reducer';
import {loginMethod} from '@blocks/LoginMethod/reducer';
import documents from '@blocks/morda/documents/actions/reducers';

const stub = (state = {}) => state;

function person(state, action) {
    return personReducer(state, action);
}

const pageMessage = (state = null, action) => {
    if (action.type === 'CURRENT_PAGE_CHANGED') {
        return null;
    }

    return state;
};

const reducers = {
    dashboard,
    header,
    domik,
    person,
    common,
    social,
    captcha,
    family,
    webauthn,
    security,
    access,
    addresses,
    emails,
    billing,
    changeAvatar,
    appPasswords,
    phoneConfirm,
    devices,
    publicId,
    pageMessage,
    settings: stub,
    footer: stub,
    metrics: stub,
    monitoring: stub,
    alice,
    tracks,
    form,
    subs,
    mordaSubscriptionCards,
    am,
    bnpl: stub,
    phones,
    loginMethod,
    documents
};

export default reducers;
