import api from '@blocks/api';
import reloadCaptcha from '@components/Captcha/actions/reloadCaptcha';

export const PASSWORD_CHANGE_TEXT = 'PASSWORD_CHANGE_TEXT';
export const CHANGE_PASSWORD_SHOW_TIPS = 'CHANGE_PASSWORD_SHOW_TIPS';
export const CHANGE_PASSWORD_SET_ERROR = 'CHANGE_PASSWORD_SET_ERROR';
export const CHANGE_PASSWORD_SHOW_MODAL = 'CHANGE_PASSWORD_SHOW_MODAL';
export const CHANGE_PASSWORD_TOGGLE_SECTION = 'CHANGE_PASSWORD_TOGGLE_SECTION';
export const CHANGE_PASSWORD_TOGGLE_SHOW_PASSWORD = 'CHANGE_PASSWORD_TOGGLE_SHOW_PASSWORD';
export const CHANGE_PASSWORD_VALIDATE_FIELD = 'CHANGE_PASSWORD_VALIDATE_FIELD';

export const CHANGE_PASSWORD_SUBMIT = 'CHANGE_PASSWORD_SUBMIT';
export const CHANGE_PASSWORD_SUBMIT_SUCCESS = 'CHANGE_PASSWORD_SUBMIT_SUCCESS';
export const CHANGE_PASSWORD_SUBMIT_FAIL = 'CHANGE_PASSWORD_SUBMIT_FAIL';

export const CHANGE_PASSWORD_REVOKERS = 'CHANGE_PASSWORD_REVOKERS';
export const CHANGE_PASSWORD_REVOKERS_SUCCESS = 'CHANGE_PASSWORD_REVOKERS_SUCCESS';
export const CHANGE_PASSWORD_REVOKERS_FAIL = 'CHANGE_PASSWORD_REVOKERS_FAIL';

export const CHANGE_PASSWORD_GET_STRENGTH = 'CHANGE_PASSWORD_GET_STRENGTH';
export const CHANGE_PASSWORD_GET_STRENGTH_SUCCESS = 'CHANGE_PASSWORD_GET_STRENGTH_SUCCESS';
export const CHANGE_PASSWORD_GET_STRENGTH_FAIL = 'CHANGE_PASSWORD_GET_STRENGTH_FAIL';

export const CHANGE_PASSWORD_REVOKE_TOKENS = 'CHANGE_PASSWORD_REVOKE_TOKENS';
export const CHANGE_PASSWORD_REVOKE_TOKENS_SUCCESS = 'CHANGE_PASSWORD_REVOKE_TOKENS_SUCCESS';
export const CHANGE_PASSWORD_REVOKE_TOKENS_FAIL = 'CHANGE_PASSWORD_REVOKE_TOKENS_FAIL';

export function changeText({name, text}) {
    return {
        type: PASSWORD_CHANGE_TEXT,
        name,
        text
    };
}

export function showModal(show) {
    return {
        type: CHANGE_PASSWORD_SHOW_MODAL,
        show
    };
}

export function toggleSection(section) {
    return {
        type: CHANGE_PASSWORD_TOGGLE_SECTION,
        section
    };
}

export function showTipsPopup(show) {
    return {
        type: CHANGE_PASSWORD_SHOW_TIPS,
        show
    };
}

export function toggleShowPassword() {
    return {
        type: CHANGE_PASSWORD_TOGGLE_SHOW_PASSWORD
    };
}

export function validateField(value, name) {
    return {
        type: CHANGE_PASSWORD_VALIDATE_FIELD,
        value,
        name
    };
}

export function setError(error, name) {
    return {
        type: CHANGE_PASSWORD_SET_ERROR,
        error,
        name
    };
}

export function submitPassword() {
    return function(dispatch, getState) {
        const state = getState();
        const {
            common: {retpath, isPDD, origin, csrf, track_id},
            password
        } = state;
        const {captcha, currentPassword, newPassword, passwordStrength, errors} = password;

        ['captcha', 'currentPassword', 'newPassword', 'repeatPassword'].forEach((key) => {
            dispatch(validateField(password[key], key));
        });

        if (Object.values(errors).filter((error) => error !== null).length > 0) {
            return;
        }
        if (passwordStrength.value === -1) {
            return;
        }

        dispatch({
            type: CHANGE_PASSWORD_SUBMIT
        });

        api.request('/profile/password/submit', {
            retpath,
            is_pdd: isPDD,
            origin,
            csrf,
            track_id,
            captcha,
            captcha_key: state.captcha.key,
            csrf_token: csrf,
            current_password: currentPassword,
            password: newPassword
        })
            .done((result) => {
                dispatch({
                    type: CHANGE_PASSWORD_SUBMIT_SUCCESS,
                    track_id: result.track_id
                });
                dispatch(getRevokers());
            })
            .fail((res) => {
                dispatch({
                    type: CHANGE_PASSWORD_SUBMIT_FAIL,
                    errors: res.errors
                });
            })
            .always(() => {
                dispatch(reloadCaptcha());
            });
    };
}

export function getRevokers() {
    return function(dispatch, getState) {
        const state = getState();
        const {
            settings: {language},
            common: {csrf}
        } = state;

        dispatch({
            type: CHANGE_PASSWORD_REVOKERS
        });

        api.request('/profile/password/revokers', {lang: language, csrf_token: csrf})
            .done((res) => {
                dispatch({
                    type: CHANGE_PASSWORD_REVOKERS_SUCCESS,
                    appPasswords: res.appPasswords,
                    devicesList: res.devicesList,
                    allOtherTokens: res.allOtherTokens
                });
                dispatch(showModal(true));
            })
            .fail((error) => {
                dispatch({
                    type: CHANGE_PASSWORD_REVOKERS_SUCCESS,
                    error
                });
            });
    };
}

export function revokeTokens(tokens, section) {
    return function(dispatch, getState) {
        const state = getState();
        const {uid, csrf} = getState().common;
        const lang = state.settings.language;
        const tokenString = tokens.join(',');

        dispatch({
            type: CHANGE_PASSWORD_REVOKE_TOKENS
        });

        api.request('apppasswords.tokens-revoke', {tokens: tokenString, uid, csrf_token: csrf, lang})
            .done(() => {
                dispatch({
                    type: CHANGE_PASSWORD_REVOKE_TOKENS_SUCCESS,
                    section,
                    tokens
                });
            })
            .fail((error) => {
                dispatch({
                    type: CHANGE_PASSWORD_REVOKE_TOKENS_FAIL,
                    error
                });
            });
    };
}

export function revokeGlobal(section) {
    return function(dispatch, getState) {
        const state = getState();
        const track_id = state.password.track_id;
        const {retpath = '/profile', csrf} = state.common;
        const data = {
            track_id,
            csrf_token: csrf,
            revoke_web_sessions: section === 'webSessions' || section === 'all',
            revoke_tokens: section === 'tokens' || section === 'all',
            revoke_app_passwords: section === 'appPasswords' || section === 'all'
        };

        dispatch({
            type: CHANGE_PASSWORD_REVOKE_TOKENS
        });

        api.request('/profile/password/revoke', data)
            .done(() => {
                if (section === 'all') {
                    location.replace(retpath);
                }

                dispatch({
                    type: CHANGE_PASSWORD_REVOKE_TOKENS_SUCCESS,
                    section
                });
            })
            .fail((error) => {
                dispatch({
                    type: CHANGE_PASSWORD_REVOKE_TOKENS_FAIL,
                    error
                });
            });
    };
}

export function getPasswordStrength(password) {
    return function(dispatch, getState) {
        const state = getState();
        const {
            common: {track_id, uid}
        } = state;

        dispatch({
            type: CHANGE_PASSWORD_GET_STRENGTH
        });

        api.request('password', {password, track_id, uid, login: state.person.login})
            .done((res) => {
                dispatch({
                    type: CHANGE_PASSWORD_GET_STRENGTH_SUCCESS,
                    validationWarnings: res.validation_warnings,
                    validationErrors: res.validation_errors
                });
            })
            .fail((error) => {
                dispatch({
                    type: CHANGE_PASSWORD_GET_STRENGTH_FAIL,
                    error
                });
            });
    };
}
