import React, {Component} from 'react';
import PropTypes from 'prop-types';
import classnames from 'classnames';

const MAX_SCORE_SYMBOLS = 7;

class PasswordLine extends Component {
    render() {
        const {strength, text} = this.props;
        const length = text.length;

        let strengthScore = Math.min(length, MAX_SCORE_SYMBOLS);

        // eslint-disable-next-line no-useless-escape
        [/\d/, /[0-9.,`!@#$%^&*()":;?_+=\\|\/{}\[\]<>]/, [/[a-z]/, /[A-Z]/]].forEach(function(regexp) {
            if (Array.isArray(regexp)) {
                const match = regexp.every((r) => r.test(text));

                if (match) {
                    strengthScore += 1;
                }
            } else if (regexp.test(text)) {
                strengthScore += 1;
            }
        });
        const width = -(100 - strengthScore * 10);
        const style = {transform: `translateX(${width}%)`};

        return (
            <div>
                <div className='changepass__line'>
                    <div
                        className={classnames('changepass__line-inner', {
                            'changepass__line-inner_unacceptable': strength === -1,
                            'changepass__line-inner_weak': strength === 0,
                            'changepass__line-inner_strong': strength === 1
                        })}
                        style={style}
                    />
                </div>
            </div>
        );
    }
}

PasswordLine.propTypes = {
    text: PropTypes.string,
    strength: PropTypes.number.isRequired
};

PasswordLine.defaulProps = {
    value: ''
};

export default PasswordLine;
