import React, {Component} from 'react';
import PropTypes from 'prop-types';

const messages = {
    complete_social: i18n('Errors.account_without_password'),
    password_change_forbidden: i18n('_AUTH_.pdd_password_change_forbidden'),
    'account.2fa_enabled': i18n('_AUTH_.pdd_password_change_forbidden'),
    'account.without_password': i18n('_AUTH_.pdd_password_change_forbidden'),
    'account.disabled_with_money': i18n('_AUTH_.pdd_password_change_forbidden'),
    'account.disabled': i18n('_AUTH_.pdd_password_change_forbidden')
};

class PasswordMessage extends Component {
    render() {
        return (
            <div className='changepass'>
                <h1 className='changepass__title'>{i18n('Frontend.title.changepassword')}</h1>
                <p className='chagepass__message' dangerouslySetInnerHTML={{__html: messages[this.props.code]}} />
            </div>
        );
    }
}

PasswordMessage.propTypes = {
    code: PropTypes.string.isRequired
};

export {PasswordMessage};
