import u from 'updeep';
import {
    PASSWORD_CHANGE_TEXT,
    CHANGE_PASSWORD_SHOW_MODAL,
    CHANGE_PASSWORD_SET_ERROR,
    CHANGE_PASSWORD_TOGGLE_SECTION,
    CHANGE_PASSWORD_TOGGLE_SHOW_PASSWORD,
    CHANGE_PASSWORD_VALIDATE_FIELD,
    CHANGE_PASSWORD_SHOW_TIPS,
    CHANGE_PASSWORD_REVOKERS,
    CHANGE_PASSWORD_REVOKERS_SUCCESS,
    CHANGE_PASSWORD_SUBMIT,
    CHANGE_PASSWORD_SUBMIT_FAIL,
    CHANGE_PASSWORD_SUBMIT_SUCCESS,
    CHANGE_PASSWORD_GET_STRENGTH_SUCCESS,
    CHANGE_PASSWORD_REVOKE_TOKENS,
    CHANGE_PASSWORD_REVOKE_TOKENS_FAIL,
    CHANGE_PASSWORD_REVOKE_TOKENS_SUCCESS
} from './actions';

export default function password(state = {}, action) {
    let newState;

    switch (action.type) {
        case PASSWORD_CHANGE_TEXT: {
            const text = action.text;
            const errors = {};

            let tips;

            if (action.name === 'newPassword') {
                tips = [];

                if (text.length >= 6) {
                    tips.push('tooshort');
                }
                if (text.match(/[a-z]/) && text.match(/[A-Z]/)) {
                    tips.push('uppercase');
                }
                if (text.match(/[0-9]/)) {
                    tips.push('numbers');
                }
            } else {
                tips = state.fullFilledTips;
            }
            if (action.name === 'repeatPassword') {
                if (text !== state.newPassword && text.length > 0) {
                    errors.repeatPassword = 'not_matched';
                } else if (text === state.newPassword && text.length > 0) {
                    errors.repeatPassword = 'matched';
                } else {
                    errors.repeatPassword = null;
                }
            }

            newState = u(
                {
                    [action.name]: action.text,
                    errors,
                    fullFilledTips: u.constant(tips)
                },
                state
            );
            break;
        }
        case CHANGE_PASSWORD_VALIDATE_FIELD: {
            const {name, value} = action;

            let error = null;

            if (value.length === 0) {
                error = 'empty';
            }
            if (name === 'repeatPassword' && value !== state.newPassword) {
                error = 'not_matched';
            }

            newState = u(
                {
                    errors: {
                        [name]: error
                    }
                },
                state
            );
            break;
        }
        case CHANGE_PASSWORD_SET_ERROR: {
            const {error, name} = action;

            newState = u(
                {
                    errors: {
                        [name]: error
                    }
                },
                state
            );
            break;
        }
        case CHANGE_PASSWORD_TOGGLE_SECTION: {
            const section = action.section;
            const opened = !state.openedSections[section];

            newState = u.updateIn(`openedSections.${action.section}`, opened, state);
            break;
        }
        case CHANGE_PASSWORD_TOGGLE_SHOW_PASSWORD: {
            newState = u(
                {
                    showPassword: !state.showPassword
                },
                state
            );
            break;
        }
        case CHANGE_PASSWORD_SUBMIT: {
            newState = u(
                {
                    loading: 'form'
                },
                state
            );
            break;
        }
        case CHANGE_PASSWORD_SUBMIT_SUCCESS: {
            newState = u(
                {
                    track_id: action.track_id,
                    loading: null
                },
                state
            );
            break;
        }
        case CHANGE_PASSWORD_SUBMIT_FAIL: {
            const errors = {};
            const mappings = {
                password: 'currentPassword',
                captcha: 'captcha'
            };

            action.errors.forEach(function(error) {
                const [fieldName, errorCode] = error.split('.');
                const key = mappings[fieldName];

                errors[key] = errorCode;
            });

            newState = u(
                {
                    loading: null,
                    errors: u.constant(errors)
                },
                state
            );
            break;
        }
        case CHANGE_PASSWORD_REVOKERS: {
            newState = u(
                {
                    loading: 'modal'
                },
                state
            );
            break;
        }
        case CHANGE_PASSWORD_REVOKE_TOKENS: {
            newState = u(
                {
                    deletingTokens: true
                },
                state
            );
            break;
        }
        case CHANGE_PASSWORD_REVOKE_TOKENS_SUCCESS: {
            const sectionName = action.section;
            const tokens = action.tokens;
            const prevSection = state[sectionName];

            let section;

            if (sectionName === 'webSessions') {
                newState = u(
                    {
                        showWebSessions: false,
                        deletingTokens: false
                    },
                    state
                );
                break;
            }

            if (sectionName === 'deviceList') {
                section = {
                    tokens: u.reject((el) => tokens.includes(el.id), prevSection.tokens)
                };
            } else {
                section = u.reject(function(el) {
                    return tokens.includes(el.id);
                }, prevSection);
            }

            newState = u(
                {
                    deletingTokens: false,
                    [sectionName]: section
                },
                state
            );
            break;
        }
        case CHANGE_PASSWORD_REVOKE_TOKENS_FAIL: {
            newState = u(
                {
                    deletingTokens: false
                },
                state
            );
            break;
        }
        case CHANGE_PASSWORD_REVOKERS_SUCCESS: {
            newState = u(
                {
                    loading: null,
                    appPasswords: action.appPasswords,
                    devicesList: action.devicesList,
                    allOtherTokens: action.allOtherTokens
                },
                state
            );
            break;
        }
        case CHANGE_PASSWORD_GET_STRENGTH_SUCCESS: {
            const {validationErrors, validationWarnings} = action;

            let passwordStrength;

            if (validationErrors) {
                passwordStrength = {
                    value: -1,
                    code: validationErrors[0].code
                };
            } else if (validationWarnings) {
                passwordStrength = {
                    value: 0,
                    code: validationWarnings[0].code
                };
            } else {
                passwordStrength = {
                    value: 1,
                    code: 'strong'
                };
            }
            newState = u(
                {
                    passwordStrength
                },
                state
            );
            break;
        }
        case CHANGE_PASSWORD_SHOW_MODAL: {
            newState = u(
                {
                    showRevokersModal: action.show
                },
                state
            );
            break;
        }
        case CHANGE_PASSWORD_SHOW_TIPS: {
            newState = u(
                {
                    showPasswordTips: action.show
                },
                state
            );
            break;
        }
        default:
            newState = state;
    }

    return newState;
}
