import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {UniversalTileList} from '@components/UniversalTileList';
import {Tumbler} from '@components/Tumbler';
import {SmsIcon, Sms2faIcon, PhoneAsLoginIcon, PhoneAsEmailIcon} from '../../Icons';
import {PAGES} from '../../const';
import {metrics} from '../../utils';

import './MainAddBlock.styl';

const b = cn('MainAddBlock');

const TEXTS = {
    title: i18n('Phones.phones.v2.add-block.title'),
    description: i18n('Phones.phones.v2.add-block.description'),
    sms2faTile: {
        title: i18n('Phones.phones.v2.add-block.sms2fa.title'),
        description: i18n('Phones.phones.v2.add-block.sms2fa.description')
    },
    authBySmsTile: {
        title: i18n('Phones.phones.v2.add-block.authBySms.title'),
        description: i18n('Phones.phones.v2.add-block.authBySms.description')
    },
    loginAliasTile: {
        title: i18n('Phones.phones.v2.add-block.login-alias.title'),
        description: i18n('Phones.phones.v2.add-block.login-alias.description')
    },
    emailAliasTile: {
        title: i18n('Phones.phones.v2.add-block.email-alias.title'),
        description: i18n('Phones.phones.v2.add-block.email-alias.description')
    }
};

const NOTIFICATIONS = {
    authBySmsOn: {text: i18n('Phones.phones.v2.notification.authBySms.on'), iconType: 'message'},
    authBySmsOff: {text: i18n('Phones.phones.v2.notification.authBySms.off'), iconType: 'message'}
};

export class MainAddBlock extends React.Component {
    state = {isSms2faShown: false, isAuthBySmsShown: false, isLoginAliasShown: false, isEmailAliasShown: false};
    constructor(props) {
        super(props);

        const {is2faEnabled, isNeoPhonish, isSocialchik, isLiteUser, isSuperLiteUser, isPDD} = props;

        this.state = {
            isSms2faShown: !(isNeoPhonish || is2faEnabled || isSocialchik || isSuperLiteUser),
            isAuthBySmsShown: !(isNeoPhonish || is2faEnabled || isSocialchik || isSuperLiteUser || isPDD),
            isLoginAliasShown: !isPDD,
            isEmailAliasShown: !(isSocialchik || isLiteUser || isNeoPhonish || isPDD)
        };
    }
    sms2faHandler = () => {
        const {phoneRequestSecureCodeSubmit, goToPage} = this.props;

        phoneRequestSecureCodeSubmit().done(() => goToPage({page: PAGES.manageSms2fa}));
    };

    authBySmsHandler = () => {
        const {toggleAuthBySms, smsCodeLoginForbidden} = this.props;

        metrics.send(['Вход по смс', smsCodeLoginForbidden ? 'включен' : 'выключен']);
        toggleAuthBySms({
            notifications: smsCodeLoginForbidden ? [NOTIFICATIONS.authBySmsOn] : [NOTIFICATIONS.authBySmsOff]
        });
    };

    enableLoginAliasSubmit = () => {
        const {enableLoginAliasSubmit, goToPage} = this.props;

        enableLoginAliasSubmit().done(() => {
            goToPage({page: PAGES.manageLoginAlias});
        });
    };

    disableLoginAliasSubmit = () => {
        const {havePassword, disableLoginAliasSubmit, goToPage} = this.props;

        disableLoginAliasSubmit().done(() => havePassword && goToPage({page: PAGES.manageLoginAlias}));
    };

    emailAliasHandler = () => {
        const {manageEmailAlias, isEmailAlias} = this.props;

        manageEmailAlias().done(() => {
            metrics.send(['Телефон как почта', isEmailAlias ? 'выключен' : 'включен']);
        });
    };

    renderTiles = () => {
        const {
            isSms2faEnabled,
            smsCodeLoginForbidden,
            isLoginAlias,
            isEmailAlias,
            numberMaskedOriginal,
            tld,
            inQuarantine
        } = this.props;
        const {isSms2faShown, isAuthBySmsShown, isLoginAliasShown, isEmailAliasShown} = this.state;

        return (
            <UniversalTileList
                tiles={[
                    isSms2faShown && {
                        type: 'block',
                        leftComponent: <Sms2faIcon />,
                        rightComponent: <Tumbler size='m' checked={isSms2faEnabled} />,
                        preventRightComponentClick: true,
                        title: TEXTS.sms2faTile.title,
                        description: TEXTS.sms2faTile.description,
                        handler: this.sms2faHandler,
                        dataT: 'phones.settings.sms2fa',
                        hasLeftComponentBg: true,
                        disabled: inQuarantine
                    },
                    isAuthBySmsShown && {
                        type: 'block',
                        leftComponent: <SmsIcon />,
                        rightComponent: <Tumbler size='m' checked={!smsCodeLoginForbidden} />,
                        preventRightComponentClick: true,
                        title: TEXTS.authBySmsTile.title,
                        description: TEXTS.authBySmsTile.description,
                        handler: this.authBySmsHandler,
                        dataT: 'phones.settings.authBySms',
                        hasLeftComponentBg: true,
                        disabled: !isLoginAlias || inQuarantine
                    },
                    isLoginAliasShown && {
                        type: 'block',
                        leftComponent: <PhoneAsLoginIcon />,
                        rightComponent: <Tumbler size='m' checked={isLoginAlias} />,
                        preventRightComponentClick: true,
                        title: TEXTS.loginAliasTile.title,
                        description: TEXTS.loginAliasTile.description,
                        handler: isLoginAlias ? this.disableLoginAliasSubmit : this.enableLoginAliasSubmit,
                        dataT: 'phones.settings.alias.login',
                        hasLeftComponentBg: true,
                        disabled: inQuarantine
                    },
                    isEmailAliasShown && {
                        type: 'block',
                        leftComponent: <PhoneAsEmailIcon />,
                        rightComponent: <Tumbler size='m' checked={isEmailAlias} />,
                        preventRightComponentClick: true,
                        title: TEXTS.emailAliasTile.title,
                        description: TEXTS.emailAliasTile.description
                            .replace('%number', numberMaskedOriginal)
                            .replace('%tld', tld),
                        handler: this.emailAliasHandler,
                        dataT: 'phones.settings.alias.email',
                        hasLeftComponentBg: true,
                        disabled: !isLoginAlias || inQuarantine
                    }
                ]}
            />
        );
    };

    render() {
        return (
            <div className={b()}>
                <h2 className={b('title')}>{TEXTS.title}</h2>

                <div className={b('description')}>{TEXTS.description}</div>

                <div className={b('tiles')}>{this.renderTiles()}</div>
            </div>
        );
    }
}

MainAddBlock.propTypes = {
    isSms2faEnabled: PropTypes.bool,
    is2faEnabled: PropTypes.bool,
    isLoginAlias: PropTypes.bool,
    isEmailAlias: PropTypes.bool,
    havePassword: PropTypes.bool,
    isNeoPhonish: PropTypes.bool,
    isSocialchik: PropTypes.bool,
    isLiteUser: PropTypes.bool,
    isSuperLiteUser: PropTypes.bool,
    isPDD: PropTypes.bool,
    smsCodeLoginForbidden: PropTypes.bool,
    numberMaskedOriginal: PropTypes.string,
    tld: PropTypes.string,
    goToPage: PropTypes.func,
    phoneRequestSecureCodeSubmit: PropTypes.func,
    enableLoginAliasSubmit: PropTypes.func,
    disableLoginAliasSubmit: PropTypes.func,
    toggleAuthBySms: PropTypes.func,
    manageEmailAlias: PropTypes.func,
    inQuarantine: PropTypes.bool
};
