import {connect} from 'react-redux';
import {MainAddBlock as Block} from './MainAddBlock';
import {
    phoneRequestSecureCodeSubmit,
    goToPage,
    toggleAuthBySms,
    enableLoginAliasSubmit,
    disableLoginAliasSubmit,
    manageEmailAlias
} from '../../actions';

const mapStateToProps = ({
    phones: {restore = []} = {},
    access: {isSms2faEnabled, is2faEnabled} = {},
    settings: {tld} = {},
    person: {
        havePassword,
        isSocialchik,
        isLiteUser,
        isNeoPhonish,
        isSuperLiteUser,
        isPDD,
        loginOptions: {smsCodeLoginForbidden = false} = {}
    } = {}
}) => {
    const restorePhone = restore[0] || {};
    const {isLoginAlias, isEmailAlias, numberMaskedOriginal} = restorePhone;
    const {operation: {inQuarantine} = {}} = restorePhone;

    return {
        havePassword,
        isSocialchik,
        isLiteUser,
        isSuperLiteUser,
        isPDD,
        isSms2faEnabled,
        is2faEnabled,
        smsCodeLoginForbidden,
        isLoginAlias,
        isEmailAlias,
        numberMaskedOriginal,
        tld,
        isNeoPhonish,
        inQuarantine
    };
};

const mapDispatchToProps = {
    phoneRequestSecureCodeSubmit,
    toggleAuthBySms,
    goToPage,
    enableLoginAliasSubmit,
    disableLoginAliasSubmit,
    manageEmailAlias
};

export const MainAddBlock = connect(mapStateToProps, mapDispatchToProps)(Block);
