import {connect} from 'react-redux';
import {MainPhonesTiles as Tiles} from './MainPhonesTiles';
import {goToPage, goToSettingsPage} from '../../actions';
import {getDaysToQuarantineFinish} from '../../utils';

const mapStateToProps = ({
    access = {},
    person: {havePassword, isLiteUser, isNeoPhonish, isSocialchik} = {},
    phones: {other = [], restore = []} = {}
}) => {
    const defaultRestorePhone = restore[0] || {};
    const {
        operation: restorePhoneOperation = {},
        number: defaultRestorePhoneNumber = '',
        id: restorePhoneId,
        isDefault: isRestoreDefault
    } = defaultRestorePhone;
    const {type: restoreOperationType, inQuarantine: isRestoreQuarantine, finished} = restorePhoneOperation;

    return {
        access,
        havePassword,
        isLiteUser,
        isNeoPhonish,
        isSocialchik,
        restore,
        other,
        hasRestorePhone: Boolean(restore.length),
        hasOtherPhone: Boolean(other.length),
        restorePhoneId,
        isRestoreDefault,
        restoreOperationType,
        isRestoreQuarantine,
        defaultRestorePhoneNumber,
        quarantineEnd: getDaysToQuarantineFinish(finished)
    };
};

const mapDispatchToProps = {
    goToPage,
    goToSettingsPage
};

export const MainPhonesTiles = connect(mapStateToProps, mapDispatchToProps)(Tiles);
