import {connect} from 'react-redux';
import {PhoneSettings as Settings} from './PhoneSettings';
import {
    goToPage,
    goToMainPage,
    cancelOperation,
    manageNotify,
    setCurrentPhoneId,
    setNotificationsState
} from '../../actions';
import {getDaysToQuarantineFinish} from '../../utils';

const mapStateToProps = ({
    access: {isSms2faEnabled, is2faEnabled, hasQuestion} = {},
    person: {havePassword, isLiteUser, isNeoPhonish, isSocialchik, isSuperLiteUser} = {},
    settings: {isTouch} = {},
    phones: {other = [], restore = [], otherInReplaceQuarantine = [], currentPhone = {}} = {}
}) => {
    const defaultRestorePhone = restore[0] || {};
    const {operation: restorePhoneOperation = {}} = defaultRestorePhone;
    const {type: restoreOperationType, inQuarantine: isRestoreQuarantine, finished} = restorePhoneOperation;
    const phoneForReplaceSecure = (otherInReplaceQuarantine[0] || {}).number;
    const {isSecure, number: phoneNumber, isDefault, id: phoneId} = currentPhone;

    return {
        havePassword,
        isLiteUser,
        isNeoPhonish,
        isSocialchik,
        isSuperLiteUser,
        isTouch,
        restore,
        other,
        hasRestorePhone: Boolean(restore.length),
        hasOtherPhone: Boolean(other.length),
        isSecure,
        phoneId,
        isRestoreQuarantine,
        isDefault,
        phoneNumber,
        restoreOperationType,
        quarantineEnd: getDaysToQuarantineFinish(finished),
        phoneForReplaceSecure,
        isSms2faEnabled,
        is2faEnabled,
        hasQuestion
    };
};

const mapDispatchToProps = {
    goToPage,
    goToMainPage,
    cancelOperation,
    manageNotify,
    setCurrentPhoneId,
    setNotificationsState
};

export const PhoneSettings = connect(mapStateToProps, mapDispatchToProps)(Settings);
