import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {metrics} from '../../utils';
import {Button} from '@components/Button';
import {Spin} from '@components/Spin';
import {cn} from '@bem-react/classname';
import './PhonesButton.styl';

const b = cn('PhonesButton');

export class PhonesButton extends Component {
    onClick = (event) => {
        const {metric, onClick} = this.props;

        if (metric) {
            metrics.send(metric);
        }

        if (onClick) {
            onClick(event);
        }
    };
    render() {
        const {children, view, text, hideMobile, dataT, progress, showLoader, disabled, type} = this.props;
        const dataTPrefix = dataT ? `phones:button:${dataT}` : 'phones:button';

        return (
            <div className={b({hideMobile})} data-t={`${dataTPrefix}:wrap`}>
                <Button
                    width='max'
                    type={type || 'button'}
                    view={showLoader ? 'clear' : view}
                    size='l'
                    onClick={this.onClick}
                    disabled={disabled}
                    data-t={dataTPrefix}
                    progress={progress}
                >
                    {showLoader ? (
                        <Spin progress={true} size='l' />
                    ) : (
                        <div className={b('content')}>
                            <div className={b('text')}>{text || children || ' '}</div>
                        </div>
                    )}
                </Button>
            </div>
        );
    }
}

PhonesButton.propTypes = {
    view: PropTypes.oneOf(['action', 'default', 'transparent', 'plus', 'clear']).isRequired,
    text: PropTypes.string,
    type: PropTypes.string,
    metric: PropTypes.arrayOf(PropTypes.string),
    children: PropTypes.node,
    onClick: PropTypes.func,
    dataT: PropTypes.string,
    hideMobile: PropTypes.bool,
    progress: PropTypes.bool,
    disabled: PropTypes.bool,
    showLoader: PropTypes.bool
};

PhonesButton.defaultProps = {
    type: 'button'
};
