import {connect} from 'react-redux';
import {PhonesCodePassConfirm} from './PhonesCodePassConfirm';
import {updateValues, updateErrors} from '@blocks/actions/form';
import {setPhoneConfirmMethod} from '@blocks/actions/phoneConfirm';
import {getFormValues, isMobile, getFormErrors, isAndroidAm} from '@blocks/selectors';
import {FIELDS_NAMES} from '@components/Field';

const mapStateToProps = (state = {}, {name = 'phoneCode'}) => {
    const values = getFormValues(state);
    const code = values[FIELDS_NAMES.PHONE_CODE];
    const errors = getFormErrors(state);
    const {phones = {}} = state;
    const {
        isLoading,
        denyResendUntil,
        isPasswordRequired,
        isCodeRequired,
        isCaptchaRequired,
        isCodeConfirmed,
        isPasswordConfirmed
    } = phones;

    return {
        code,
        isWithCodeFormatExp: !isAndroidAm(state),
        denyResendUntil,
        error: errors[name] && errors[name].text,
        isMobile: isMobile(state),
        isLoading,
        isPasswordRequired,
        isCodeRequired,
        isCaptchaRequired,
        isCodeConfirmed,
        isPasswordConfirmed
    };
};

const mapDispatchToProps = {
    updateValues,
    updateErrors,
    setPhoneConfirmMethod
};

const ConnectedPhonesCodePassConfirm = connect(mapStateToProps, mapDispatchToProps)(PhonesCodePassConfirm);

export {ConnectedPhonesCodePassConfirm as PhonesCodePassConfirm};
