import React from 'react';
import PropTypes from 'prop-types';
import {redirectToRetpathFromWebview} from '@blocks/utils';
import {cn} from '@bem-react/classname';
import './PhonesLayout.styl';

const b = cn('PhonesLayout');
const dataT = 'phones:layout';

export class PhonesLayout extends React.Component {
    onBackButtonClick = () => {
        const {goToMainPage, onPhonesProcessEnd, onBackButtonClick, isWebview, retpath} = this.props;

        if (isWebview) {
            return redirectToRetpathFromWebview(retpath);
        }

        if (onBackButtonClick) {
            return onBackButtonClick();
        }

        onPhonesProcessEnd({needToCancelOperation: true});
        goToMainPage();
    };

    render() {
        const {isModal, children, hideBackButton, backButtonMarginBottom, isWebview, contentOnly} = this.props;

        return (
            <div className={b({isModal, isWebview, contentOnly})} data-t={dataT}>
                <div className={b('wrapper')}>
                    {!isModal && !hideBackButton && (
                        <button
                            data-t={`${dataT}:back`}
                            className={b('backButton', {backButtonMarginBottom, isCrossBackButton: isWebview})}
                            onClick={this.onBackButtonClick}
                        >
                            <div className={b('backButtonIcon', {isCrossBackButton: isWebview})} />
                        </button>
                    )}
                    {children}
                </div>
            </div>
        );
    }
}

PhonesLayout.propTypes = {
    isModal: PropTypes.bool,
    hideBackButton: PropTypes.bool,
    backButtonMarginBottom: PropTypes.bool,
    onBackButtonClick: PropTypes.func,
    goToMainPage: PropTypes.func,
    onPhonesProcessEnd: PropTypes.func,
    children: PropTypes.node,
    isWebview: PropTypes.bool,
    contentOnly: PropTypes.bool,
    retpath: PropTypes.string
};
