import {connect} from 'react-redux';
import {PhonesLayout} from './PhonesLayout';
import {goToMainPage, onPhonesProcessEnd} from '../../actions';

const mapStateToProps = (state = {}, ownProps = {}) => {
    const {
        settings: {isTouch, isWebview = false} = {},
        common: {retpath} = {},
        phones: {contentOnly = false} = {}
    } = state;

    const {contentOnly: contentOnlyOwnProps} = ownProps;

    return {
        isTouch,
        isWebview,
        contentOnly: contentOnlyOwnProps || contentOnly,
        retpath
    };
};

const mapDispatchToProps = {goToMainPage, onPhonesProcessEnd};

const ConnectedPhonesLayout = connect(mapStateToProps, mapDispatchToProps)(PhonesLayout);

export {ConnectedPhonesLayout as PhonesLayout};
