import React from 'react';
import PropTypes from 'prop-types';
import {Modal} from '@components/Modal';
import {ERRORS_MAP, MODAL_CONTENT_RENDER_TIMEOUT} from '../../../const';
import {getPageComponent} from '../pages';

const calcIsModalVisible = ({modal}) => Boolean(modal);

export class PhonesPageSelectorModal extends React.Component {
    constructor(props) {
        super(props);
        const isModalVisible = calcIsModalVisible(props);

        this.state = {
            modal: props.modal,
            isModalVisible,
            isModalContentRendered: isModalVisible
        };
    }
    componentDidUpdate(prevProps) {
        const {modal} = this.props;
        const {modal: prevModal} = prevProps;

        const isPrevVisible = calcIsModalVisible(prevProps);
        const isNewVisible = calcIsModalVisible(this.props);

        if (isNewVisible !== isPrevVisible) {
            this.setModalVisibleState(isNewVisible);
        }
        if (prevModal !== modal && Boolean(modal)) {
            this.setModalPage(modal);
        }
    }
    setModalPage = (modal) => this.setState({modal});

    setModalVisibleState = (isVisible) => {
        const {isPasswordVisible, togglePasswordVisibilityState} = this.props;

        this.setState(isVisible ? {isModalVisible: true, isModalContentRendered: true} : {isModalVisible: false});
        !isVisible &&
            setTimeout(() => this.setState({isModalContentRendered: false, modal: null}), MODAL_CONTENT_RENDER_TIMEOUT);

        if (isVisible && isPasswordVisible) {
            togglePasswordVisibilityState();
        }
    };
    closeModal = () => {
        const {page, setPhonesPage, onPhonesProcessEnd} = this.props;

        onPhonesProcessEnd({needToCancelOperation: true});
        setPhonesPage({page, modal: null});
    };
    render() {
        const {error, ...otherProps} = this.props;
        const {modal, isModalVisible, isModalContentRendered} = this.state;
        const PageComponent = getPageComponent(modal);
        const errorForShowModal = ERRORS_MAP[error];

        return (
            <Modal
                visible={isModalVisible}
                onCloserClick={!errorForShowModal ? this.closeModal : undefined}
                onClose={!errorForShowModal ? this.closeModal : undefined}
                dataT='phones:modal'
            >
                {PageComponent && isModalContentRendered && (
                    <PageComponent {...otherProps} isModal={true} error={error} page={modal} />
                )}
            </Modal>
        );
    }
}

PhonesPageSelectorModal.propTypes = {
    page: PropTypes.string,
    modal: PropTypes.string,
    isPasswordVisible: PropTypes.bool,
    error: PropTypes.string,
    onPhonesProcessEnd: PropTypes.func,
    setPhonesPage: PropTypes.func,
    togglePasswordVisibilityState: PropTypes.func.isRequired
};
