import * as Pages from '../../pages';
import {PAGES} from '../../const';

const PAGE_COMPONENTS = {
    [PAGES.main]: Pages.PhonesMainPage,
    [PAGES.phoneSettings]: Pages.PhoneSettingsPage,
    [PAGES.deleteSecurePhone]: Pages.DeleteSecurePhonePage,
    [PAGES.addPhone]: Pages.AddPhonePage,
    [PAGES.replacePhone]: Pages.ReplacePhonePage,
    [PAGES.manageSms2fa]: Pages.ManageSms2faPage,
    [PAGES.manageLoginAlias]: Pages.ManageLoginAliasPage,
    [PAGES.deleteSimplePhone]: Pages.DeleteSimplePhonePage,
    [PAGES.deleteSecureAlert]: Pages.DeleteSecureAlertPage,
    [PAGES.replaceSecureAlert]: Pages.ReplaceSecureAlertPage,
    [PAGES.tutorialQuestion]: Pages.TutorialQuestionPage,
    [PAGES.error]: Pages.ErrorPage
};

export const getPageComponent = (page) => PAGE_COMPONENTS[page] || null;
