export const PAGES = {
    main: 'main',
    phoneSettings: 'phoneSettings',
    deleteSecurePhone: 'deleteSecurePhone',
    addPhone: 'addPhone',
    replacePhone: 'replacePhone',
    manageSms2fa: 'manageSms2fa',
    manageLoginAlias: 'manageLoginAlias',
    deleteSimplePhone: 'deleteSimplePhone',
    deleteSecureAlert: 'deleteSecureAlert',
    replaceSecureAlert: 'replaceSecureAlert',
    tutorialQuestion: 'tutorialQuestion',
    error: 'error'
};

export const OPERATION_TYPES = {
    remove: 'remove',
    replace: 'replace',
    aliasify: 'aliasify',
    dealiasify: 'dealiasify',
    sms2faOn: 'sms2faOn',
    sms2faOff: 'sms2faOff',
    securify: 'securify',
    bind: 'bind',
    notify: 'notify',
    mark: 'mark'
};

export const PHONES_METRIC_PREFIX = 'Страница телефонов';

export const SECONDS_TO_NEXT_CODE_SEND = 30;

export const MODAL_CONTENT_RENDER_TIMEOUT = 200;

export const ROUTES = {
    main: ['/profile/phones', '/profile/phones/'],
    add: ['/profile/phones/add', '/profile/phones/add/']
};

export const ERRORS_MAP = {
    default: {
        title: i18n('Phones.phones.v2.error.title.default'),
        text: i18n('Phones.phones.v2.error.text.default'),
        buttonText: i18n('Phones.phones.v2.error.button')
    },
    'csrf_token.invalid': {
        title: i18n('Phones.phones.v2.error.title.default'),
        text: i18n('Phones.phones.v2.error.text.default'),
        buttonText: i18n('Phones.phones.v2.error.button')
    },
    'phone_secure.not_found': {
        title: i18n('Phones.phones.v2.error.title.default'),
        text: i18n('Phones.phones.v2.error.text.default'),
        buttonText: i18n('Phones.phones.v2.error.button')
    },
    'account.disabled': {
        title: i18n('Phones.phones.v2.error.title.default'),
        text: i18n('Phones.phones.v2.error.text.default'),
        buttonText: i18n('Phones.phones.v2.error.button')
    },
    'account.disabled_on_deletion': {
        title: i18n('Phones.phones.v2.error.title.default'),
        text: i18n('Phones.phones.v2.error.text.default'),
        buttonText: i18n('Phones.phones.v2.error.button')
    },
    'operation.exists': {
        title: i18n('Phones.phones.v2.error.title.default'),
        text: i18n('Phones.phones.v2.error.text.default'),
        buttonText: i18n('Phones.phones.v2.error.button')
    },
    'operation.not_found': {
        title: i18n('Phones.phones.v2.error.title.default'),
        text: i18n('Phones.phones.v2.error.text.default'),
        buttonText: i18n('Phones.phones.v2.error.button')
    },
    'phone.is_bank_phonenumber_alias': {
        title: '',
        text: i18n('Phones.phones.v2.blocked_number_error'),
        buttonText: i18n('Phones.phones.v2.error.button')
    }
};

export const PLACE_BY_ORIGIN = {
    test_origin: 'test_origin'
};
