import React from 'react';
import PropTypes from 'prop-types';
import {AddPhonePage} from '../../pages/AddPhonePage';
import {ErrorPage} from '../../pages/ErrorPage';
import {PAGES} from '../../const';

const PAGE_COMPONENTS = {
    [PAGES.addPhone]: AddPhonePage,
    [PAGES.error]: ErrorPage
};

export class AddPhone extends React.Component {
    render() {
        const {place, page} = this.props;
        const PageComponent = PAGE_COMPONENTS[page] || null;

        return <PageComponent place={place} />;
    }
}

AddPhone.propTypes = {
    place: PropTypes.string,
    page: PropTypes.string
};
