import React from 'react';
import PropTypes from 'prop-types';
import {PhonesPageSelectorFull} from '../../components/PhonesPageSelector/Full';
import {PhonesPageSelectorModal} from '../../components/PhonesPageSelector/Modal';
import {NotificationList} from '@components/NotificationList';

export class Phones extends React.Component {
    render() {
        const {setNotificationsState, notifications} = this.props;

        return (
            <>
                <PhonesPageSelectorFull />
                <PhonesPageSelectorModal />
                <NotificationList setNotificationsState={setNotificationsState} notifications={notifications} />
            </>
        );
    }
}

Phones.propTypes = {
    setNotificationsState: PropTypes.func.isRequired,
    notifications: PropTypes.object
};
