import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {Phone} from '@screens/Phone';
import {PhonesLayout} from '../../components/PhonesLayout';
import './PhonesAddPhoneLayout.styl';

const b = cn('PhonesAddPhoneLayout');
const dataT = 'phones:add-phone:layout';

const TEXTS = {
    TITLE: {
        family: i18n('Frontend.phone-bind-confirm.title-step1.family'),
        profileAuthBlock: i18n('Frontend.phone-bind-confirm.title-step1.profileAuthBlock'),
        default: i18n('Phones.phones.v2.add-phone.default.title'),
        test_origin: 'test test'
    },
    DESCRIPTION: {
        family: i18n('Frontend.phone-bind-confirm.desc-step1.family'),
        default: i18n('Phones.phones.v2.add-phone.default.description'),
        test_origin: 'test test test test test'
    },
    WARNING: {
        family: i18n('Frontend.phone-bind-confirm.warining-step1.family'),
        test_origin: 'test test test test test test test test testttt'
    },
    BUTTON: {
        family: i18n('_AUTH_.next'),
        profileAuthBlock: i18n('Frontend.phone.confrim-btn.profileAuthBlock'),
        default: i18n('_AUTH_.next')
    }
};

const DECORATIONS = {
    default: 'default',
    family: 'family'
};

export class PhonesAddPhoneLayout extends React.Component {
    confirmationSubmit = (event) => {
        const {confirmationSubmit} = this.props;

        event && event.preventDefault();

        confirmationSubmit();
    };

    render() {
        const {place = 'default', isModal, hideBackButton, forceDecoreNegativeMargin} = this.props;

        const decor = DECORATIONS[place];
        const warningText = TEXTS.WARNING[place];
        const title = TEXTS.TITLE[place];
        const description = TEXTS.DESCRIPTION[place];

        return (
            <PhonesLayout
                isModal={isModal}
                hideBackButton={hideBackButton}
                backButtonMarginBottom={!decor}
                {...this.props}
            >
                <div className={b()} data-t={dataT}>
                    {decor && (
                        <div
                            className={b('decor', {
                                decor,
                                negativeTopMargin: forceDecoreNegativeMargin || !hideBackButton
                            })}
                            aria-hidden='true'
                        />
                    )}

                    <div className={b('title', {negativeTopMargin: !decor && !hideBackButton})}>
                        {title || TEXTS.TITLE.default}
                    </div>

                    {description && <div className={b('description')}>{description}</div>}

                    <form className={b('form')} method='post' onSubmit={this.confirmationSubmit}>
                        <Phone
                            hideHead={true}
                            buttonText={TEXTS.BUTTON[place] || TEXTS.BUTTON.default}
                            onConfirm={this.confirmationSubmit}
                            onRetry={this.confirmationSubmit}
                        />
                    </form>
                    {warningText && (
                        <div className={b('warning')}>
                            <div className={b('warningIcon')} />
                            <div className={b('warningText')}>{warningText}</div>
                        </div>
                    )}
                </div>
            </PhonesLayout>
        );
    }
}

PhonesAddPhoneLayout.propTypes = {
    decor: PropTypes.string,
    isModal: PropTypes.bool,
    hideBackButton: PropTypes.bool,
    mode: PropTypes.string,
    confirmationSubmit: PropTypes.func,
    onSuccess: PropTypes.func,
    phoneId: PropTypes.string,
    phoneCode: PropTypes.string,
    resendCode: PropTypes.func,
    place: PropTypes.string,
    forceDecoreNegativeMargin: PropTypes.bool
};
