import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {LoaderId} from '@components/LoaderId';
import {PhonesButton} from '@blocks/phones/components/PhonesButton';
import {PhonesLayout} from '@blocks/phones/components/PhonesLayout';
import './PhonesAlertLayout.styl';

const b = cn('PhonesAlertLayout');
const baseDataT = 'phones:alert:layout';

export const PhonesAlertLayout = ({
    decor,
    title,
    text,
    textAsDangerouslySet = false,
    textLink,
    onTextLinkClick,
    textView,
    isModal,
    hideBackButton,
    onBackButtonClick,
    children,
    buttons = [],
    isLoading,
    dataTPostfix = '',
    isCenterTextAlign = false
}) => {
    if (isLoading) {
        return (
            <div className={b('spin')}>
                <LoaderId />
            </div>
        );
    }

    return (
        <PhonesLayout
            isModal={isModal}
            hideBackButton={hideBackButton}
            onBackButtonClick={onBackButtonClick}
            backButtonMarginBottom={!decor}
        >
            <div className={b({isCenterTextAlign})} data-t={dataTPostfix ? `${baseDataT}:${dataTPostfix}` : baseDataT}>
                {decor && (
                    <div className={b('decor', {decor, negativeTopMargin: !hideBackButton})} aria-hidden='true' />
                )}
                <h2 className={b('title', {isModal, noText: !text, noContent: !children})}>{title}</h2>
                {text && (
                    <div className={b('textWrapper')}>
                        {!textAsDangerouslySet && <div className={b('text', {view: textView})}>{text}</div>}
                        {textAsDangerouslySet && (
                            <div className={b('text', {view: textView})} dangerouslySetInnerHTML={{__html: text}} />
                        )}
                        {textLink && (
                            <a className={b('textLink')} onClick={onTextLinkClick}>
                                {textLink}
                            </a>
                        )}
                    </div>
                )}
                {children && <div className={b('children')}>{children}</div>}
                {Boolean(buttons.length) && (
                    <div className={b('buttons')}>
                        {buttons.map((button, index) => button && <PhonesButton {...button} key={index} />)}
                    </div>
                )}
            </div>
        </PhonesLayout>
    );
};

PhonesAlertLayout.propTypes = {
    decor: PropTypes.string,
    title: PropTypes.string,
    text: PropTypes.oneOfType([PropTypes.string, PropTypes.bool]),
    textAsDangerouslySet: PropTypes.bool,
    textLink: PropTypes.oneOfType([PropTypes.string, PropTypes.bool]),
    onTextLinkClick: PropTypes.func,
    textView: PropTypes.string,
    isModal: PropTypes.bool,
    isLoading: PropTypes.bool,
    hideBackButton: PropTypes.bool,
    onBackButtonClick: PropTypes.func,
    children: PropTypes.node,
    buttons: PropTypes.arrayOf(
        PropTypes.shape({
            text: PropTypes.string,
            view: PropTypes.oneOf(['action', 'transparent', 'default']),
            onClick: PropTypes.func
        })
    ),
    dataTPostfix: PropTypes.string,
    isCenterTextAlign: PropTypes.bool
};
