import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {PhonesCodePassConfirm} from '../../components/PhonesCodePassConfirm';
import {PhonesLayout} from '../../components/PhonesLayout';
import './PhonesConfirmCodeLayout.styl';

const b = cn('PhonesConfirmCodeLayout');
const dataT = 'phones:confirm-code:layout';

export class PhonesConfirmCodeLayout extends React.Component {
    render() {
        const {
            isModal,
            hideBackButton,
            forceDecoreNegativeMargin,
            resendCode,
            number,
            isPasswordRequired,
            isCodeRequired,
            commitConfirmation
        } = this.props;

        const decor = isPasswordRequired && !isCodeRequired ? 'password' : 'default';

        return (
            <PhonesLayout
                isModal={isModal}
                hideBackButton={hideBackButton}
                backButtonMarginBottom={!decor}
                {...this.props}
            >
                <div className={b()} data-t={dataT}>
                    {decor && (
                        <div
                            className={b('decor', {
                                decor,
                                negativeTopMargin: forceDecoreNegativeMargin || !hideBackButton
                            })}
                            aria-hidden='true'
                        />
                    )}
                    <PhonesCodePassConfirm
                        number={number}
                        isAutoSubmitPrevent={true}
                        onConfirm={commitConfirmation}
                        onRetry={resendCode}
                    />
                </div>
            </PhonesLayout>
        );
    }
}

PhonesConfirmCodeLayout.propTypes = {
    number: PropTypes.string,
    isModal: PropTypes.bool,
    hideBackButton: PropTypes.bool,
    isPasswordRequired: PropTypes.bool,
    isCodeRequired: PropTypes.bool,
    commitConfirmation: PropTypes.func,
    onSuccess: PropTypes.func,
    phoneId: PropTypes.string,
    phoneCode: PropTypes.string,
    resendCode: PropTypes.func,
    forceDecoreNegativeMargin: PropTypes.bool
};
