import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {Checkbox} from '@components/Checkbox';
import {PhonesButton} from '../../components/PhonesButton';
import {PhonesLayout} from '../../components/PhonesLayout';
import './PhonesConfirmPhoneLayout.styl';

const b = cn('PhonesConfirmPhoneLayout');
const dataT = 'phones:confirm-phone:layout';

const TEXTS = {
    warningDescription: {
        replace: i18n('Phones.phones.v2.confirm-phone.restore.warning.replace'),
        remove: i18n('Phones.phones.v2.confirm-phone.restore.warning.remove')
    },
    description: i18n('Phones.phones.v2.confirm-phone.description'),
    checkBoxLabel: i18n('Phones.phones.v2.confirm-phone.checkbox.label'),
    warningLink: i18n('Phones.phones.v2.confirm-phone.warning.link'),
    sendSms: i18n('Phones.phones.v2.confirm-phone.button.sms'),
    next: i18n('_AUTH_.next')
};

export class PhonesConfirmPhoneLayout extends React.Component {
    render() {
        const {
            decor,
            number,
            isModal,
            isLoading,
            hideBackButton,
            hasPhoneAccess,
            setPhoneAccess,
            onSubmit,
            onWarningClick,
            place
        } = this.props;

        return (
            <PhonesLayout isModal={isModal} hideBackButton={hideBackButton} backButtonMarginBottom={!decor}>
                <div className={b()} data-t={dataT}>
                    {decor && (
                        <div className={b('decor', {decor, negativeTopMargin: !hideBackButton})} aria-hidden='true' />
                    )}
                    <div className={b('text')}>{TEXTS.description}</div>
                    <h2 className={b('number')}>{number}</h2>

                    <div className={b('checkbox')}>
                        <Checkbox
                            size='m'
                            name='hasPhoneAccess'
                            checked={!hasPhoneAccess}
                            disabled={isLoading}
                            onChange={setPhoneAccess}
                            label={TEXTS.checkBoxLabel}
                            view='yellow'
                            dataT='checkbox.has.phone'
                        />
                    </div>

                    {!hasPhoneAccess && (
                        <div className={b('warning')}>
                            <div className={b('warningDescription')}>{TEXTS.warningDescription[place]}</div>
                            <a className={b('warningLink')} onClick={onWarningClick}>
                                {TEXTS.warningLink}
                            </a>
                        </div>
                    )}

                    <div className={b('buttons')}>
                        <PhonesButton
                            view='action'
                            text={hasPhoneAccess ? TEXTS.sendSms : TEXTS.next}
                            onClick={onSubmit}
                            dataT='confirm.phone'
                        />
                    </div>
                </div>
            </PhonesLayout>
        );
    }
}

PhonesConfirmPhoneLayout.propTypes = {
    decor: PropTypes.string,
    place: PropTypes.string,
    number: PropTypes.string,
    isModal: PropTypes.bool,
    isLoading: PropTypes.bool,
    hideBackButton: PropTypes.bool,
    hasPhoneAccess: PropTypes.bool,
    setPhoneAccess: PropTypes.func,
    onSubmit: PropTypes.func,
    onWarningClick: PropTypes.func
};
