import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {PhonesLayout} from '../../components/PhonesLayout';
import {MainPhonesTiles} from '../../components/MainPhonesTiles';
import {MainAddBlock} from '../../components/MainAddBlock';

import './PhonesMainLayout.styl';

const b = cn('PhonesMainLayout');
const dataT = 'phones:main:layout';

const LINKS = {
    toInfoLanding: 'https://id.yandex.%tld%/howtoprotectyourid'
};

const TEXTS = {
    title: i18n('Phones.phones.v2.main.title'),
    description: i18n('Phones.phones.v2.main.description'),
    descriptionLink: i18n('Phones.phones.v2.main.description.link')
};

export class PhonesMainLayout extends React.Component {
    render() {
        const {showAddBlock, tld} = this.props;

        return (
            <PhonesLayout hideBackButton={true} dataT={dataT}>
                <div className={b()}>
                    <h2 className={b('title')}>{TEXTS.title}</h2>
                    <div className={b('description')}>
                        {TEXTS.description}&nbsp;
                        <a className={b('descriptionLink')} href={LINKS.toInfoLanding.replace('%tld%', tld)}>
                            {TEXTS.descriptionLink}
                        </a>
                    </div>
                    <MainPhonesTiles />
                    {showAddBlock && <MainAddBlock />}
                </div>
            </PhonesLayout>
        );
    }
}

PhonesMainLayout.propTypes = {
    showAddBlock: PropTypes.bool,
    tld: PropTypes.string
};
