import React, {PureComponent} from 'react';
import PropTypes from 'prop-types';
import {AddPhonePage} from '../../pages/AddPhonePage';
import Modal from '@components/Wrappers/Modal.jsx';
import {cn} from '@bem-react/classname';
import './AddPhoneModal.styl';

const b = cn('AddPhoneModal');

export class AddPhoneModal extends PureComponent {
    cleanup = (editMode, cb) => {
        const {setEditMode, onPhonesProcessEnd} = this.props;

        setEditMode(editMode);
        onPhonesProcessEnd();
        typeof cb === 'function' && cb();
    };

    closeModal = () => {
        const {onClose} = this.props;

        this.cleanup('', onClose);
    };

    onSuccess = () => {
        const {editModeOnSuccess = '', onSuccess} = this.props;

        this.cleanup(editModeOnSuccess, onSuccess);
    };

    render() {
        const {isOpened, isTouch, place = '', closerView, shouldTurnOnSms2fa = false} = this.props;

        return (
            <Modal
                visible={isOpened}
                dataT='add-phone-modal'
                className={b({isTouch})}
                closerView={closerView}
                onCloserClick={this.closeModal}
                onClose={this.closeModal}
            >
                {isOpened && (
                    <AddPhonePage
                        place={place}
                        isModal={true}
                        onSuccess={this.onSuccess}
                        shouldTurnOnSms2fa={shouldTurnOnSms2fa}
                    />
                )}
            </Modal>
        );
    }
}

AddPhoneModal.propTypes = {
    isOpened: PropTypes.bool.isRequired,
    isTouch: PropTypes.bool.isRequired,
    setEditMode: PropTypes.func.isRequired,
    onPhonesProcessEnd: PropTypes.func.isRequired,
    onSuccess: PropTypes.func,
    onClose: PropTypes.func,
    place: PropTypes.string,
    closerView: PropTypes.string,
    editModeOnSuccess: PropTypes.string,
    shouldTurnOnSms2fa: PropTypes.bool
};
