import React from 'react';
import PropTypes from 'prop-types';
import {PhonesAddPhoneLayout} from '../../layouts/PhonesAddPhoneLayout';
import {PhonesConfirmCodeLayout} from '../../layouts/PhonesConfirmCodeLayout';
import {redirectToRetpathFromWebview} from '@blocks/utils';
import {WEBVIEW_STATUS_SUCCESS} from '@blocks/constants';
import {metrics} from '../../utils';
import {PLACE_BY_ORIGIN} from '../../const';

const NOTIFICATIONS = {
    addPhone: {text: i18n('Phones.phones.v2.notification.phone.add'), iconType: 'ok'},
    authBySms: {text: i18n('Phones.phones.v2.notification.authBySms.on'), iconType: 'message'}
};

export class AddPhonePage extends React.Component {
    componentWillUnmount = () => {
        const {shouldResetOnUnmount = false, onPhonesProcessEnd} = this.props;

        if (shouldResetOnUnmount) {
            onPhonesProcessEnd();
        }
    };

    commitConfirmation = () => {
        const {phoneBindSecureCommit, goToMainPage, isWebview, retpath, onSuccess, shouldTurnOnSms2fa} = this.props;
        const notificationWithSms = [NOTIFICATIONS.addPhone, NOTIFICATIONS.authBySms];
        const notificationWithoutSms = [NOTIFICATIONS.addPhone];
        const bindSecureNotifications = {notificationWithSms, notificationWithoutSms};

        phoneBindSecureCommit({notifications: bindSecureNotifications, shouldTurnOnSms2fa}).done(() => {
            metrics.send(['Привязан основной телефон']);

            if (onSuccess) {
                return onSuccess();
            }

            if (isWebview) {
                return redirectToRetpathFromWebview(retpath, WEBVIEW_STATUS_SUCCESS);
            }

            goToMainPage();
        });
    };

    render() {
        const {
            isModal,
            processedNumber,
            isConfirmationCodeSent,
            phoneBindSecureSubmit,
            contentOnly,
            forceDecoreNegativeMargin,
            origin,
            place
        } = this.props;
        const calcPlace = place || PLACE_BY_ORIGIN[origin] || 'default';

        if (isConfirmationCodeSent) {
            return (
                <PhonesConfirmCodeLayout
                    isModal={isModal}
                    hideBackButton={contentOnly || isModal}
                    contentOnly={contentOnly}
                    forceDecoreNegativeMargin={forceDecoreNegativeMargin}
                    commitConfirmation={this.commitConfirmation}
                    resendCode={phoneBindSecureSubmit}
                    number={processedNumber}
                />
            );
        }

        return (
            <PhonesAddPhoneLayout
                place={calcPlace}
                isModal={isModal}
                contentOnly={contentOnly}
                forceDecoreNegativeMargin={forceDecoreNegativeMargin}
                hideBackButton={contentOnly || isModal}
                confirmationSubmit={phoneBindSecureSubmit}
            />
        );
    }
}

AddPhonePage.propTypes = {
    isModal: PropTypes.bool,
    error: PropTypes.string,
    goToMainPage: PropTypes.func,
    phoneBindSecureCommit: PropTypes.func,
    isConfirmationCodeSent: PropTypes.bool,
    phoneBindSecureSubmit: PropTypes.func,
    onPhonesProcessEnd: PropTypes.func,
    processedNumber: PropTypes.string,
    isWebview: PropTypes.bool,
    contentOnly: PropTypes.bool,
    forceDecoreNegativeMargin: PropTypes.bool,
    origin: PropTypes.string,
    place: PropTypes.string,
    retpath: PropTypes.string,
    onSuccess: PropTypes.func,
    shouldTurnOnSms2fa: PropTypes.bool,
    shouldResetOnUnmount: PropTypes.bool
};
