import {connect} from 'react-redux';
import {goToMainPage, phoneBindSecureSubmit, phoneBindSecureCommit, onPhonesProcessEnd} from '../../actions';
import {AddPhonePage as Page} from './AddPhonePage';

const mapStateToProps = (
    {
        phones: {isConfirmationCodeSent, processedNumber, contentOnly} = {},
        settings: {isWebview, origin} = {},
        common: {retpath} = {}
    } = {},
    {contentOnly: contentOnlyOwnProps}
) => ({
    isConfirmationCodeSent,
    processedNumber,
    isWebview,
    contentOnly: contentOnlyOwnProps || contentOnly,
    origin,
    retpath
});

const mapDispatchToProps = {phoneBindSecureSubmit, phoneBindSecureCommit, goToMainPage, onPhonesProcessEnd};

export const AddPhonePage = connect(mapStateToProps, mapDispatchToProps)(Page);
