import React from 'react';
import PropTypes from 'prop-types';
import {PhonesAlertLayout} from '../../layouts/PhonesAlertLayout';
import {PAGES} from '../../const';

const TEXTS = {
    question: {
        title: i18n('Phones.phones.v2.alert.remove.question.title'),
        description: i18n('Phones.phones.v2.alert.remove.question.description'),
        link: i18n('Phones.phones.v2.alert.remove.question.link'),
        buttonNext: i18n('_AUTH_.next'),
        buttonClose: i18n('Phones.phones.v2.alert.close')
    },
    superLiteOrSocial: {
        title: i18n('Phones.phones.v2.alert.remove.superLiteOrSocial.title'),
        description: i18n('Phones.phones.v2.alert.remove.superLiteOrSocial.description'),
        buttonNext: i18n('_AUTH_.next'),
        buttonClose: i18n('Phones.phones.v2.alert.close')
    },
    neophonish: {
        title: i18n('Phones.phones.v2.alert.remove.neophonish.title'),
        description: i18n('Phones.phones.v2.alert.remove.neophonish.description'),
        buttonNext: i18n('_AUTH_.next'),
        buttonClose: i18n('Phones.phones.v2.alert.close')
    },
    sms2fa: {
        title: i18n('Phones.phones.v2.alert.remove.sms2fa.title'),
        description: i18n('Phones.phones.v2.alert.remove.sms2fa.description'),
        buttonClose: i18n('Phones.phones.v2.alert.good')
    }
};

const LINKS = {
    changeKVKO: '/profile/change-hint',
    upgrade: '/profile/upgrade'
};

export class DeleteSecureAlertPage extends React.Component {
    goToChangeKVKO = () => {
        const {currentPage} = this.props;

        window.location.href = `${LINKS.changeKVKO}?retpath=${encodeURIComponent(currentPage)}`;
    };

    goToUpgrade = () => {
        const {currentPage} = this.props;

        window.location.href = `${LINKS.upgrade}?retpath=${encodeURIComponent(currentPage)}`;
    };

    goToTutorialQuestionPage = () => {
        const {goToPage} = this.props;

        goToPage({page: PAGES.tutorialQuestion});
    };

    getButtonsQuestionWarning = () => {
        const {goToMainPage} = this.props;

        return [
            {
                text: TEXTS.question.buttonNext,
                view: 'action',
                onClick: this.goToChangeKVKO
            },
            {
                text: TEXTS.question.buttonClose,
                view: 'transparent',
                onClick: goToMainPage
            }
        ];
    };

    getButtonsUpgrade = () => {
        const {goToMainPage} = this.props;

        return [
            {
                text: TEXTS.question.buttonNext,
                view: 'action',
                onClick: this.goToUpgrade
            },
            {
                text: TEXTS.question.buttonClose,
                view: 'transparent',
                onClick: goToMainPage
            }
        ];
    };

    getButtonsSms2faWarning = () => {
        const {goToMainPage} = this.props;

        return [
            {
                text: TEXTS.sms2fa.buttonClose,
                view: 'action',
                onClick: goToMainPage
            }
        ];
    };

    render() {
        const {isModal, hasQuestion, isNeoPhonish, isSocialchik, isSuperLiteUser, isSms2faEnabled} = this.props;

        if (isSocialchik || isSuperLiteUser) {
            return (
                <PhonesAlertLayout
                    decor='default'
                    title={TEXTS.superLiteOrSocial.title}
                    text={TEXTS.superLiteOrSocial.description}
                    isModal={isModal}
                    buttons={this.getButtonsUpgrade()}
                    isCenterTextAlign={true}
                />
            );
        }

        if (isNeoPhonish) {
            return (
                <PhonesAlertLayout
                    decor='default'
                    title={TEXTS.neophonish.title}
                    text={TEXTS.neophonish.description}
                    isModal={isModal}
                    buttons={this.getButtonsUpgrade()}
                    isCenterTextAlign={true}
                />
            );
        }

        if (!hasQuestion) {
            return (
                <PhonesAlertLayout
                    decor='default'
                    title={TEXTS.question.title}
                    text={TEXTS.question.description}
                    textLink={TEXTS.question.link}
                    onTextLinkClick={this.goToTutorialQuestionPage}
                    isModal={isModal}
                    buttons={this.getButtonsQuestionWarning()}
                    isCenterTextAlign={true}
                />
            );
        }

        if (isSms2faEnabled) {
            return (
                <PhonesAlertLayout
                    decor='default'
                    title={TEXTS.sms2fa.title}
                    text={TEXTS.sms2fa.description}
                    isModal={isModal}
                    buttons={this.getButtonsSms2faWarning()}
                    isCenterTextAlign={true}
                />
            );
        }

        return null;
    }
}

DeleteSecureAlertPage.propTypes = {
    isModal: PropTypes.bool,
    goToMainPage: PropTypes.func,
    goToPage: PropTypes.func,
    isSms2faEnabled: PropTypes.bool,
    hasQuestion: PropTypes.bool,
    currentPage: PropTypes.string,
    havePassword: PropTypes.bool,
    isNeoPhonish: PropTypes.bool,
    isSocialchik: PropTypes.bool,
    isSuperLiteUser: PropTypes.bool
};
