import React from 'react';
import PropTypes from 'prop-types';
import {PhonesConfirmPhoneLayout} from '../../layouts/PhonesConfirmPhoneLayout';
import {PhonesConfirmCodeLayout} from '../../layouts/PhonesConfirmCodeLayout';
import {PhonesAlertLayout} from '../../layouts/PhonesAlertLayout';
import {metrics} from '../../utils';

const TEXTS = {
    tutorial: {
        title: i18n('Phones.phones.v2.tutorial.quarantine.title'),
        description: i18n('Phones.phones.v2.tutorial.quarantine.description'),
        buttonTutorialOk: i18n('Phones.phones.v2.tutorial.ok')
    }
};

const NOTIFICATIONS = {
    remove: i18n('Phones.phones.v2.notification.remove')
};

export class DeleteSecurePhonePage extends React.Component {
    state = {
        showTutorial: false
    };

    manageTutorial = () => {
        this.setState({showTutorial: !this.state.showTutorial});
    };

    openProfileDevices = () => {
        window.open('/profile/devices', '_blank');
    };

    getButtonsTutorial = () => {
        return [
            {
                text: TEXTS.tutorial.buttonTutorialOk,
                view: 'action',
                onClick: this.manageTutorial
            }
        ];
    };

    commitConfirmationWithAccess = () => {
        const {checkCode, checkPassword, removeSecurePhoneCommit, goToMainPage, setNotificationsState} = this.props;

        Promise.all([checkCode(), checkPassword()]).then(() =>
            removeSecurePhoneCommit().done(() => {
                metrics.send(['Удален основной телефон']);
                setNotificationsState({
                    isVisible: true,
                    notificationsList: [
                        {
                            text: NOTIFICATIONS.remove,
                            iconType: 'trash'
                        }
                    ]
                });
                goToMainPage();
            })
        );
    };

    commitConfirmationWithoutAccess = () => {
        const {checkPassword, removeSecurePhoneCommit, goToMainPage} = this.props;

        checkPassword().done(() =>
            removeSecurePhoneCommit().done(() => {
                metrics.send(['Запущено удаление основного телефона с карантином']);
                goToMainPage();
            })
        );
    };

    render() {
        const {
            isModal,
            isConfirmationCodeSent,
            resendCode,
            numberRestore,
            removeSecurePhoneSubmit,
            hasPhoneAccess
        } = this.props;
        const {showTutorial} = this.state;

        if (showTutorial) {
            return (
                <PhonesAlertLayout
                    decor='tutorial'
                    title={TEXTS.tutorial.title}
                    text={TEXTS.tutorial.description}
                    textAsDangerouslySet={true}
                    isModal={isModal}
                    buttons={this.getButtonsTutorial()}
                    onBackButtonClick={this.manageTutorial}
                />
            );
        }

        if (isConfirmationCodeSent) {
            return (
                <PhonesConfirmCodeLayout
                    isModal={isModal}
                    commitConfirmation={
                        hasPhoneAccess ? this.commitConfirmationWithAccess : this.commitConfirmationWithoutAccess
                    }
                    resendCode={resendCode}
                    number={numberRestore}
                />
            );
        }

        return (
            <PhonesConfirmPhoneLayout
                place='remove'
                decor='delete'
                isModal={isModal}
                onSubmit={removeSecurePhoneSubmit}
                onWarningClick={this.manageTutorial}
            />
        );
    }
}

DeleteSecurePhonePage.propTypes = {
    isModal: PropTypes.bool,
    removeSecurePhoneSubmit: PropTypes.func,
    removeSecurePhoneCommit: PropTypes.func,
    checkCode: PropTypes.func,
    checkPassword: PropTypes.func,
    goToMainPage: PropTypes.func,
    setNotificationsState: PropTypes.func,
    resendCode: PropTypes.func,
    numberRestore: PropTypes.string,
    isConfirmationCodeSent: PropTypes.bool,
    hasPhoneAccess: PropTypes.bool
};
