import {connect} from 'react-redux';
import {DeleteSecurePhonePage as Page} from './DeleteSecurePhonePage';
import {
    removeSecurePhoneSubmit,
    removeSecurePhoneCommit,
    checkCode,
    checkPassword,
    goToMainPage,
    resendCode,
    setNotificationsState
} from '../../actions';

const mapStateToProps = ({phones: {restore = [], isConfirmationCodeSent, hasPhoneAccess}}) => ({
    numberRestore: (restore[0] || {}).number || '',
    isConfirmationCodeSent,
    hasPhoneAccess
});

const mapDispatchToProps = {
    removeSecurePhoneSubmit,
    removeSecurePhoneCommit,
    checkCode,
    checkPassword,
    goToMainPage,
    resendCode,
    setNotificationsState
};

export const DeleteSecurePhonePage = connect(mapStateToProps, mapDispatchToProps)(Page);
