import React from 'react';
import PropTypes from 'prop-types';
import {PhonesAlertLayout} from '../../layouts/PhonesAlertLayout';
import {metrics} from '../../utils';

const TEXTS = {
    title: i18n('Phones.phones.v2.other.remove.alert.title'),
    description: i18n('Phones.phones.v2.other.remove.alert.description'),
    buttonRemove: i18n('Phones.phones.v2.settings.other.remove'),
    buttonClose: i18n('Phones.phones.v2.alert.close')
};

const NOTIFICATIONS = {
    remove: i18n('Phones.phones.v2.notification.remove')
};

export class DeleteSimplePhonePage extends React.Component {
    deleteSimplePhone = () => {
        const {goToMainPage, deleteSimplePhone, currentSimplePhoneId, setNotificationsState} = this.props;

        deleteSimplePhone(currentSimplePhoneId).done(() => {
            metrics.send(['Удален дополнительный телефон']);
            setNotificationsState({
                isVisible: true,
                notificationsList: [
                    {
                        text: NOTIFICATIONS.remove,
                        iconType: 'trash'
                    }
                ]
            });
            goToMainPage();
        });
    };

    getButtons = () => {
        const {isLoading, goToMainPage} = this.props;

        return [
            {
                text: TEXTS.buttonRemove,
                view: 'default',
                progress: isLoading,
                onClick: this.deleteSimplePhone
            },
            {
                text: TEXTS.buttonClose,
                view: 'transparent',
                onClick: goToMainPage
            }
        ];
    };

    render() {
        const {isModal} = this.props;

        return (
            <PhonesAlertLayout
                decor='default'
                title={TEXTS.title}
                text={TEXTS.description}
                isModal={isModal}
                buttons={this.getButtons()}
                isCenterTextAlign={true}
            />
        );
    }
}

DeleteSimplePhonePage.propTypes = {
    isModal: PropTypes.bool,
    isLoading: PropTypes.bool,
    goToMainPage: PropTypes.func,
    setNotificationsState: PropTypes.func,
    deleteSimplePhone: PropTypes.func,
    currentSimplePhoneId: PropTypes.number
};
