import React from 'react';
import PropTypes from 'prop-types';
import {PhonesAlertLayout} from '../../layouts/PhonesAlertLayout';
import {ERRORS_MAP} from '../../const';
import {reloadPage, metrics} from '../../utils';

export class ErrorPage extends React.Component {
    componentDidMount() {
        metrics.send(['Показ окна с ошибкой']);
    }

    getButton = (text) => ({
        view: 'action',
        text,
        onClick: reloadPage
    });

    render() {
        const {isModal, error = 'default'} = this.props;
        const {title, text, buttonText} = ERRORS_MAP[error];
        const buttons = [this.getButton(buttonText)];

        return (
            <PhonesAlertLayout
                decor='error'
                title={title}
                text={text}
                isModal={isModal}
                buttons={buttons}
                hideBackButton={true}
            />
        );
    }
}

ErrorPage.propTypes = {
    isModal: PropTypes.bool,
    error: PropTypes.string
};
