import React from 'react';
import PropTypes from 'prop-types';
import {PhonesConfirmCodeLayout} from '../../layouts/PhonesConfirmCodeLayout';
import {metrics} from '../../utils';

export class ManageLoginAliasPage extends React.Component {
    commitEnableConfirmation = () => {
        const {enableLoginAliasCommit, goToMainPage} = this.props;

        enableLoginAliasCommit().done(() => {
            metrics.send(['Телефон как логин', 'включен']);
            goToMainPage();
        });
    };

    commitDisableConfirmation = () => {
        const {disableLoginAliasCommit, goToMainPage} = this.props;

        disableLoginAliasCommit().done(() => {
            metrics.send(['Телефон как логин', 'выключен']);
            goToMainPage();
        });
    };

    render() {
        const {isModal, numberRestore, enableLoginAliasSubmit, disableLoginAliasSubmit, isLoginAlias} = this.props;

        return (
            <PhonesConfirmCodeLayout
                isModal={isModal}
                commitConfirmation={isLoginAlias ? this.commitDisableConfirmation : this.commitEnableConfirmation}
                resendCode={isLoginAlias ? disableLoginAliasSubmit : enableLoginAliasSubmit}
                number={numberRestore}
            />
        );
    }
}

ManageLoginAliasPage.propTypes = {
    isModal: PropTypes.bool,
    goToMainPage: PropTypes.func,
    enableLoginAliasSubmit: PropTypes.func,
    enableLoginAliasCommit: PropTypes.func,
    disableLoginAliasSubmit: PropTypes.func,
    disableLoginAliasCommit: PropTypes.func,
    numberRestore: PropTypes.string,
    isLoginAlias: PropTypes.bool
};
