import {connect} from 'react-redux';
import {ManageLoginAliasPage as Page} from './ManageLoginAliasPage';
import {
    goToMainPage,
    enableLoginAliasSubmit,
    enableLoginAliasCommit,
    disableLoginAliasSubmit,
    disableLoginAliasCommit
} from '../../actions';

const mapStateToProps = ({phones: {restore = []}}) => {
    const restorePhone = restore[0] || {};
    const {number: numberRestore, isLoginAlias} = restorePhone;

    return {
        numberRestore,
        isLoginAlias
    };
};

const mapDispatchToProps = {
    goToMainPage,
    enableLoginAliasSubmit,
    enableLoginAliasCommit,
    disableLoginAliasSubmit,
    disableLoginAliasCommit
};

export const ManageLoginAliasPage = connect(mapStateToProps, mapDispatchToProps)(Page);
