import React from 'react';
import PropTypes from 'prop-types';
import {PhonesConfirmCodeLayout} from '../../layouts/PhonesConfirmCodeLayout';
import {metrics} from '../../utils';

const NOTIFICATIONS = {
    sms2faOn: {text: i18n('Phones.phones.v2.notification.sms2fa.on'), iconType: 'message'},
    sms2faOff: {text: i18n('Phones.phones.v2.notification.sms2fa.off'), iconType: 'key'}
};

export class ManageSms2faPage extends React.Component {
    commitConfirmation = () => {
        const {sms2faCommit, goToMainPage, setNotificationsState, isSms2faEnabled} = this.props;

        sms2faCommit().done(() => {
            metrics.send(['Вход с паролем и смс', isSms2faEnabled ? 'выключен' : 'включен']);
            setNotificationsState({
                isVisible: true,
                notificationsList: [isSms2faEnabled ? NOTIFICATIONS.sms2faOff : NOTIFICATIONS.sms2faOn]
            });
            goToMainPage();
        });
    };

    render() {
        const {isModal, numberRestore, phoneRequestSecureCodeSubmit} = this.props;

        return (
            <PhonesConfirmCodeLayout
                isModal={isModal}
                commitConfirmation={this.commitConfirmation}
                resendCode={phoneRequestSecureCodeSubmit}
                number={numberRestore}
            />
        );
    }
}

ManageSms2faPage.propTypes = {
    isModal: PropTypes.bool,
    phoneRequestSecureCodeSubmit: PropTypes.func,
    goToMainPage: PropTypes.func,
    numberRestore: PropTypes.string,
    sms2faCommit: PropTypes.func,
    setNotificationsState: PropTypes.func,
    isSms2faEnabled: PropTypes.bool
};
