import {connect} from 'react-redux';
import {
    goToMainPage,
    checkCode,
    checkPassword,
    replaceSecurePhoneCommit,
    replaceSecurePhoneSubmit,
    resendCode,
    setReplaceSecondStep,
    setPasswordRequired,
    setCaptchaRequired,
    setReplaceAddPhoneStep,
    clearFields,
    setNotificationsState
} from '../../actions';
import {ReplacePhonePage as Page} from './ReplacePhonePage';

const mapStateToProps = ({
    phones: {
        isConfirmationCodeSent,
        processedNumber,
        restore = [],
        isSecondReplaceStep,
        hasPhoneAccess,
        isReplaceAddPhoneStep
    } = {},
    person: {havePassword} = {}
}) => ({
    numberRestore: (restore[0] || {}).number || '',
    isConfirmationCodeSent,
    processedNumber,
    isSecondReplaceStep,
    hasPhoneAccess,
    isReplaceAddPhoneStep,
    havePassword
});

const mapDispatchToProps = {
    checkCode,
    checkPassword,
    goToMainPage,
    replaceSecurePhoneCommit,
    replaceSecurePhoneSubmit,
    resendCode,
    setReplaceSecondStep,
    setPasswordRequired,
    setCaptchaRequired,
    setReplaceAddPhoneStep,
    clearFields,
    setNotificationsState
};

export const ReplacePhonePage = connect(mapStateToProps, mapDispatchToProps)(Page);
