import React from 'react';
import PropTypes from 'prop-types';
import {PhonesAlertLayout} from '../../layouts/PhonesAlertLayout';

const TEXTS = {
    title: i18n('Phones.phones.v2.alert.remove.neophonish.title'),
    description: i18n('Phones.phones.v2.settings.replace.description'),
    buttonNext: i18n('_AUTH_.next'),
    buttonClose: i18n('Phones.phones.v2.alert.close')
};

const LINKS = {
    upgrade: '/profile/upgrade'
};

export class ReplaceSecureAlertPage extends React.Component {
    goToUpgrade = () => {
        const {currentPage} = this.props;

        window.location.href = `${LINKS.upgrade}?retpath=${encodeURIComponent(currentPage)}`;
    };

    getButtons = () => {
        const {goToMainPage} = this.props;

        return [
            {
                text: TEXTS.buttonNext,
                view: 'action',
                onClick: this.goToUpgrade
            },
            {
                text: TEXTS.buttonClose,
                view: 'transparent',
                onClick: goToMainPage
            }
        ];
    };

    render() {
        const {isModal} = this.props;

        return (
            <PhonesAlertLayout
                decor='default'
                title={TEXTS.title}
                text={TEXTS.description}
                isModal={isModal}
                buttons={this.getButtons()}
                isCenterTextAlign={true}
            />
        );
    }
}

ReplaceSecureAlertPage.propTypes = {
    isModal: PropTypes.bool,
    goToMainPage: PropTypes.func,
    goToPage: PropTypes.func,
    currentPage: PropTypes.string
};
