import React from 'react';
import PropTypes from 'prop-types';
import {PhonesAlertLayout} from '../../layouts/PhonesAlertLayout';
import {PAGES} from '../../const';

const TEXTS = {
    title: i18n('Phones.phones.v2.tutorial.restore-tool.title'),
    description: i18n('Phones.phones.v2.tutorial.restore-tool.description'),
    buttonGoToKVKO: i18n('Phones.phones.v2.tutorial.restore-tool.button.add.kvko'),
    buttonTutorialOk: i18n('Phones.phones.v2.tutorial.ok')
};

const LINKS = {
    changeKVKO: '/profile/change-hint'
};

export class TutorialQuestionPage extends React.Component {
    goToChangeKVKO = () => {
        const {currentPage} = this.props;

        window.location.href = `${LINKS.changeKVKO}?retpath=${encodeURIComponent(currentPage)}`;
    };

    goToDeleteSecureAlertPage = () => {
        const {goToPage} = this.props;

        goToPage({page: PAGES.deleteSecureAlert});
    };

    getButtons = () => {
        return [
            {
                text: TEXTS.buttonGoToKVKO,
                view: 'action',
                onClick: this.goToChangeKVKO
            },
            {
                text: TEXTS.buttonTutorialOk,
                view: 'transparent',
                onClick: this.goToDeleteSecureAlertPage
            }
        ];
    };

    render() {
        const {isModal} = this.props;

        return (
            <PhonesAlertLayout
                decor='tutorial'
                title={TEXTS.title}
                text={TEXTS.description}
                textAsDangerouslySet={true}
                isModal={isModal}
                buttons={this.getButtons()}
                onBackButtonClick={this.goToDeleteSecureAlertPage}
            />
        );
    }
}

TutorialQuestionPage.propTypes = {
    isModal: PropTypes.bool,
    goToPage: PropTypes.func,
    currentPage: PropTypes.string
};
