import {UPDATE_RESTORE_PHONE} from '@blocks/Screens/PhoneBindConfirm/actions';

import {
    SET_PHONES_PAGE,
    SET_PHONES_ERROR,
    SET_PHONES_LOADING,
    SET_PHONE_ACCESS,
    SET_OPERATION,
    SET_DENY_RESEND_UNTIL,
    SET_PASSWORD_REQUIRED,
    SET_CODE_REQUIRED,
    SET_PHONES_CAPTCHA_REQUIRED,
    SET_CURRENT_PHONE_ID,
    SET_CONFIRMATION_CODE_SENT_STATUS,
    SET_PROCESSED_NUMBER,
    UPDATE_PHONES,
    RESET_PHONES_TEMP_VALUES,
    SET_REPLACE_SECOND_STEP,
    SET_REPLACE_ADD_PHONE_STEP,
    SET_IS_LOGIN_ALIAS_STATE,
    SET_IS_EMAIL_ALIAS_STATE,
    SET_NOTIFICATIONS_STATE,
    SET_CURRENT_PHONE
} from '../actions';

const defaultState = {
    pageInfo: {page: 'main', modal: null, isModalOpened: false},
    error: null,
    isLoading: false,
    restore: [],
    other: [],
    otherInReplaceQuarantine: [],
    completeSms2fa: false,
    hasPhoneAccess: true,
    isCodeConfirmed: false,
    isPasswordConfirmed: false,
    denyResendUntil: '',
    isPasswordRequired: false,
    isCodeRequired: false,
    isCaptchaRequired: false,
    currentSecurePhoneId: '',
    currentSimplePhoneId: '',
    isConfirmationCodeSent: false,
    processedNumber: '',
    isSecondReplaceStep: false,
    isReplaceAddPhoneStep: false,
    notifications: {
        isVisible: false,
        notificationsList: []
    },
    currentPhone: {}
};

const findPhoneIndexByPhoneId = (array, phoneId) => {
    const index = array.findIndex((phone) => phone.id === phoneId) || 0;

    return index === -1 ? 0 : index;
};

export default function phones(state = defaultState, action = {}) {
    const {type, payload} = action;

    switch (type) {
        case UPDATE_RESTORE_PHONE: {
            const newPhone = {
                id: payload.phoneId,
                number: payload.number,
                isDefault: true
            };

            return {
                ...state,
                restore: [...state.restore, newPhone]
            };
        }
        case SET_PHONES_LOADING: {
            return {
                ...state,
                isLoading: payload
            };
        }
        case SET_PHONES_ERROR: {
            return {
                ...state,
                error: payload
            };
        }
        case SET_PHONES_PAGE: {
            const {page = null, modal = null, isModalOpened = false} = payload;

            return {
                ...state,
                pageInfo: {page, modal, isModalOpened}
            };
        }
        case SET_PHONE_ACCESS: {
            return {
                ...state,
                hasPhoneAccess: !state.hasPhoneAccess
            };
        }
        case SET_OPERATION: {
            const {isSecure, phoneId, id, type} = payload;

            const arrayToUpdate = isSecure ? 'restore' : 'other';
            const operation = {
                id,
                type
            };
            const phoneIndex = findPhoneIndexByPhoneId(state[arrayToUpdate], phoneId);
            const phoneWithUpdatedOperation = {
                ...state[arrayToUpdate][phoneIndex],
                id: phoneId,
                operation
            };
            const updatedArray = state[arrayToUpdate];

            updatedArray[phoneIndex] = phoneWithUpdatedOperation;

            return {
                ...state,
                [arrayToUpdate]: updatedArray
            };
        }
        case SET_DENY_RESEND_UNTIL: {
            return {
                ...state,
                denyResendUntil: payload
            };
        }
        case SET_PASSWORD_REQUIRED: {
            return {
                ...state,
                isPasswordRequired: payload
            };
        }
        case SET_CODE_REQUIRED: {
            return {
                ...state,
                isCodeRequired: payload
            };
        }
        case SET_PHONES_CAPTCHA_REQUIRED: {
            return {
                ...state,
                isCaptchaRequired: payload
            };
        }
        case SET_CURRENT_PHONE_ID: {
            const {phoneId, isSecure} = payload;

            if (isSecure) {
                return {
                    ...state,
                    currentSecurePhoneId: phoneId
                };
            }

            return {
                ...state,
                currentSimplePhoneId: phoneId
            };
        }
        case SET_CONFIRMATION_CODE_SENT_STATUS: {
            return {
                ...state,
                isConfirmationCodeSent: payload
            };
        }
        case SET_PROCESSED_NUMBER: {
            return {
                ...state,
                processedNumber: payload
            };
        }
        case UPDATE_PHONES: {
            const {restore = [], other = [], otherInReplaceQuarantine = []} = payload;

            return {
                ...state,
                restore,
                other,
                otherInReplaceQuarantine
            };
        }
        case SET_REPLACE_SECOND_STEP: {
            return {
                ...state,
                isSecondReplaceStep: payload
            };
        }
        case SET_REPLACE_ADD_PHONE_STEP: {
            return {
                ...state,
                isReplaceAddPhoneStep: payload
            };
        }
        case SET_CURRENT_PHONE: {
            const {phoneId} = payload;
            const currentPhone = [...state.restore, ...state.other].find((phone) => phoneId === phone.id);

            return {
                ...state,
                currentPhone
            };
        }
        case SET_IS_LOGIN_ALIAS_STATE: {
            const updRestorePhone = state.restore[0] || {};

            updRestorePhone.isLoginAlias = payload;

            return {
                ...state,
                restore: [updRestorePhone]
            };
        }
        case SET_IS_EMAIL_ALIAS_STATE: {
            const updRestorePhone = state.restore[0] || {};

            updRestorePhone.isEmailAlias = payload;

            return {
                ...state,
                restore: [updRestorePhone]
            };
        }
        case SET_NOTIFICATIONS_STATE: {
            return {
                ...state,
                notifications: payload
            };
        }
        case RESET_PHONES_TEMP_VALUES: {
            return {
                ...state,
                completeSms2fa: false,
                hasPhoneAccess: true,
                isCodeConfirmed: false,
                isPasswordConfirmed: false,
                denyResendUntil: '',
                isPasswordRequired: false,
                isCodeRequired: false,
                isCaptchaRequired: false,
                currentSecurePhoneId: '',
                currentSimplePhoneId: '',
                isConfirmationCodeSent: false,
                processedNumber: '',
                isSecondReplaceStep: false,
                isReplaceAddPhoneStep: false,
                currentPhone: {}
            };
        }
        default:
            return state;
    }
}
