import commonMetrics from '@blocks/metrics';
import dayjs from 'dayjs';
import {PHONES_METRIC_PREFIX} from './const';

const sendPhonesMetric = (data = []) => commonMetrics.send([PHONES_METRIC_PREFIX, ...data]);

export const metrics = {
    send: (data = []) => sendPhonesMetric(data)
};

export const getDaysToQuarantineFinish = (finishTimestamp) => {
    const now = dayjs();
    const finished = dayjs(new Date(finishTimestamp * 1000));
    const diff = finished.diff(now, 'day', true);

    return Math.ceil(diff);
};

export const reloadPage = () => window.location.reload();
