import React from 'react';
import PropTypes from 'prop-types';
import {connect} from 'react-redux';

const User = () => null;

export class Account extends React.Component {
    shouldComponentUpdate() {
        return false;
    }

    render() {
        const {tld, isValid, yu, accounts, account, passportHost, avatarHost} = this.props;

        if (!isValid) {
            return null;
        }

        return (
            <div className='p-account'>
                <div className='p-account__user'>
                    <User
                        onlyUser={true}
                        yandexUID={yu}
                        tld={tld}
                        accounts={accounts.filter(({status}) => status !== 'DELETED' && status !== 'DISABLED')}
                        currentAccount={account}
                        avatarHost={avatarHost}
                        passportHost={passportHost}
                    />
                </div>
            </div>
        );
    }
}

Account.propTypes = {
    tld: PropTypes.string.isRequired,
    account: PropTypes.object.isRequired,
    isValid: PropTypes.bool.isRequired,
    accounts: PropTypes.array.isRequired,
    yu: PropTypes.string.isRequired,
    passportHost: PropTypes.string.isRequired,
    avatarHost: PropTypes.string.isRequired
};

export default connect(
    ({
        common: {yandexuid: yu},
        settings: {
            tld,
            passportHost,
            avatar: {host: avatarHost}
        },
        person: {isValid},
        header: {defaultAccount: account, accounts}
    }) => ({
        tld,
        isValid,
        yu,
        passportHost,
        avatarHost,
        account,
        accounts
    }),
    undefined,
    undefined,
    {
        pure: false
    }
)(Account);
