import React from 'react';
import PropTypes from 'prop-types';
import {BackIcon} from './BackIcon';
import {CloseButton} from '@blocks/pushes/components/CloseButton/CloseButton';
import {Logo} from './Logo';

export const Header = ({showMain, closePopup, b, isShowNotMe}) => {
    return (
        <div className={b('header')}>
            {isShowNotMe && (
                <button aria-label={i18n('_AUTH_.common.back')} className={b('back')} onClick={showMain}>
                    <BackIcon />
                </button>
            )}
            <div className={b('logoWrapper')}>
                <Logo />
            </div>
            <div className={b('close')}>
                <CloseButton mode={'relative'} closeHandler={closePopup} />
            </div>
        </div>
    );
};

Header.propTypes = {
    showMain: PropTypes.func.isRequired,
    closePopup: PropTypes.func.isRequired,
    b: PropTypes.func.isRequired,
    isShowNotMe: PropTypes.bool.isRequired
};
