import {connect} from 'react-redux';
import {ActivityAlert} from './ActivityAlert';
import {withResize} from '../hocs/withResize';
import {chooseAccount, setPopupSize, beginChangePasswordFlow} from '@blocks/authv2/actions/nativeMobileApi';
import {showMain, showNotMe} from './actions';

const mapStateToProps = (state = {}) => {
    const {activityAlert = {}, am = {}, settings = {}, person = {}, common = {}} = state;
    const {finishCancelUrl, finishErrorUrl, finishOkUrl} = am;
    const {yandexuid} = common;
    const {avatar = {}} = settings;
    const {host, pathname} = avatar;
    const {login, name, publicDisplayName, displayName, avatarId, havePassword, isAccountError} = person;

    if (!isAccountError) {
        const isDefaultAvatar = avatarId === '0/0-0';

        const avatarLink = `url("https://${host}${pathname
            .replace('%uid%', avatarId)
            .replace('%size%', '200')
            .replace('%login%', login)}")`;

        return {
            activityAlert,
            settings,
            login,
            name: name || publicDisplayName || displayName,
            isDefaultAvatar,
            avatarLink,
            havePassword,
            yu: yandexuid,
            isAccountError,
            finishCancelUrl,
            finishErrorUrl,
            finishOkUrl
        };
    }

    return {
        activityAlert,
        settings,
        isAccountError,
        finishCancelUrl,
        finishErrorUrl,
        finishOkUrl
    };
};

const mapDispatchToProps = {
    chooseAccount,
    beginChangePasswordFlow,
    setPopupSize,
    showMain,
    showNotMe
};

const connectedActivityAlert = connect(mapStateToProps, mapDispatchToProps)(withResize(ActivityAlert));

export {connectedActivityAlert as ActivityAlert};
