import {combineReducers} from 'redux';
import am from '@blocks/authv2/reducers/am';
import common from '@blocks/common/reducers';
import person from '@blocks/morda/personal_info/reducers';
import {ACTIVITY_ALERT_SHOW_NOT_ME, ACTIVITY_ALERT_SHOW_MAIN} from './actions/';

const stub = (state = {}) => state;

const initialState = {
    isShowNotMe: false,
    location: '',
    ip: '',
    mapUrl: '',
    browserName: '',
    date: ''
};

const rootReducer = combineReducers({
    am,
    common,
    person,
    access: stub,
    settings: stub,
    footer: stub,
    metrics: stub,
    monitoring: stub,
    tracks: stub,
    activityAlert
});

export default rootReducer;

export function activityAlert(state = initialState, action = {}) {
    switch (action.type) {
        case ACTIVITY_ALERT_SHOW_NOT_ME: {
            return {
                ...state,
                isShowNotMe: true
            };
        }
        case ACTIVITY_ALERT_SHOW_MAIN: {
            return {
                ...state,
                isShowNotMe: false
            };
        }
        default:
            return state;
    }
}
