import React, {Component} from 'react';
import PropTypes from 'prop-types';
import classnames from 'classnames';
import {Route, Switch} from 'react-router-dom';
import {changeCurrentPage} from '@blocks/common/actions';
import {Family} from '@blocks/morda/new/family';

class FamilyPush extends Component {
    routes = [
        {
            path: '/am/push/family',
            component: Family
        },
        {
            path: '/profile/family',
            component: Family
        }
    ];

    componentDidMount() {
        const dispatch = this.props.dispatch;
        const host = this.props.settings.host;

        this.props.history.listen((event) => {
            const {pathname, search} = event;
            const {action} = this.props.history;
            const url = `${host}${pathname}${search}`;

            dispatch(changeCurrentPage(url, action));
        });
    }

    render() {
        const {location} = this.props;

        return (
            <div className={classnames('layout-inner')}>
                <Switch location={location}>
                    {this.routes.map((route) => (
                        <Route
                            key={route.path}
                            path={route.path}
                            exact={true}
                            render={({match}) => {
                                const FamilyPage = route.component;

                                return <FamilyPage {...this.props} match={match} />;
                            }}
                        />
                    ))}
                </Switch>
            </div>
        );
    }
}

FamilyPush.propTypes = {
    dispatch: PropTypes.func.isRequired,
    settings: PropTypes.object.isRequired,
    router: PropTypes.object.isRequired,
    location: PropTypes.shape({
        pathname: PropTypes.string.isRequired
    }).isRequired,
    history: PropTypes.shape({
        listen: PropTypes.func.isRequired,
        action: PropTypes.string
    }).isRequired
};

export {FamilyPush};
