import {FamilyPush} from './FamilyPush';
import {withResize} from '../hocs/withResize';
import {connect} from 'react-redux';
import {withRouter} from 'react-router-dom';
import {setPopupSize} from '@blocks/authv2/actions/nativeMobileApi';

const FAMILY_PUSH_OPTIONS = {
    mode: 'fullscreen',
    cornerRadius: 0,
    horizontalMargins: 0,
    verticalMargins: 0
};

const mapStateToProps = (state) => state;

const mapDispatchToProps = (dispatch) => ({
    setPopupSize,
    dispatch
});

const connectedFamilyPush = withRouter(
    connect(mapStateToProps, mapDispatchToProps)(withResize(FamilyPush, FAMILY_PUSH_OPTIONS))
);

export {connectedFamilyPush as FamilyPush};
