import {authPrepareWithCredSuccess, authPrepareWithCredFail, startLoadingPrepareWithCred, showSuccessScreen} from './';
import api from '@blocks/api';
import metrics from '@blocks/metrics';
import {WEB_UNILINK, WEB_UNILINK_SUCCESS} from '@blocks/pushes/metrics_constants';

export const authPrepareWithCred = () => {
    return (dispatch, getState) => {
        const {am = {}, common = {}} = getState();
        const {experiments = {}} = common;
        const {flags = []} = experiments;
        const isSliderConfirmationDesign = flags.includes('slider-confirmation-design');
        const {isAm, finishOkUrl, trackId} = am;

        !isSliderConfirmationDesign && dispatch(startLoadingPrepareWithCred());

        api.request('auth-prepare-with-cred', {trackId})
            .done(({status} = {}) => {
                if (status === 'ok') {
                    metrics.send([WEB_UNILINK, WEB_UNILINK_SUCCESS]);
                    dispatch(authPrepareWithCredSuccess());

                    if (isAm) {
                        window.location = finishOkUrl;
                        return;
                    }

                    !isSliderConfirmationDesign && dispatch(showSuccessScreen());
                }
            })
            .fail((error) => {
                dispatch(authPrepareWithCredFail(error));
            });
    };
};
