/* eslint-disable max-len */
import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';

const b = cn('RightArrowIcon');

export const RightArrowIcon = ({className}) => (
    <svg
        className={b('', [className])}
        width='44'
        height='44'
        viewBox='0 0 44 44'
        fill='none'
        xmlns='http://www.w3.org/2000/svg'
    >
        <rect width='44' height='44' rx='22' fill='white' />
        <path
            d='M18.2929 15.7071C17.9024 15.3166 17.9024 14.6834 18.2929 14.2929C18.6834 13.9024 19.3166 13.9024 19.7071 14.2929L26.3536 20.9393C26.9393 21.5251 26.9393 22.4749 26.3536 23.0607L19.7071 29.7071C19.3166 30.0976 18.6834 30.0976 18.2929 29.7071C17.9024 29.3166 17.9024 28.6834 18.2929 28.2929L24.5858 22L18.2929 15.7071Z'
            fill='#FF005C'
        />
    </svg>
);

RightArrowIcon.propTypes = {
    className: PropTypes.string
};
