import {connect} from 'react-redux';
import {QrSecureAuth} from './QrSecureAuth';
import {withResize} from '../hocs/withResize';
import {chooseAccount, primaryActionTriggered, setPopupSize} from '@blocks/authv2/actions/nativeMobileApi';
import {authPrepareWithCred} from './actions/authPrepareWithCred';

const mapStateToProps = (state = {}) => {
    const {qrSecureAuth = {}, am = {}, settings = {}, auth = {}, common = {}, access = {}} = state;
    const {ua: {isTouch} = {}} = settings;
    const {avatar = {}, passportLinks = {}} = settings;
    const {auth: authUrl = ''} = passportLinks;
    const {currentPage, experiments = {}} = common;
    const {host, pathname} = avatar;
    const {is2faEnabled} = access;
    const {unitedAccounts, defaultAccount = {}, processedAccount} = auth;
    const hasUnitedAccounts = Object.keys(unitedAccounts).length !== 0;
    const authHref = `${authUrl}?retpath=${encodeURIComponent(currentPage)}`;
    const {flags = []} = experiments;
    const isSliderConfirmationDesign = flags.includes('slider-confirmation-design');

    let account = defaultAccount;

    if (isSliderConfirmationDesign) {
        account = processedAccount || defaultAccount;
    }

    if (Object.keys(account).length !== 0) {
        const {login, name, displayName, avatarId, publicDisplayName} = account;

        const avatarLink = `url("https://${host}${pathname
            .replace('%uid%', avatarId)
            .replace('%size%', '200')
            .replace('%login%', login)}")`;

        return {
            qrSecureAuth,
            settings,
            isSliderConfirmationDesign,
            name: name || displayName,
            publicDisplayName,
            hasUnitedAccounts,
            avatarLink,
            isAccountError: false,
            am,
            authHref,
            isTouch,
            is2faEnabled
        };
    }

    return {
        qrSecureAuth,
        settings,
        isSliderConfirmationDesign,
        isAccountError: true,
        am,
        isTouch
    };
};

const mapDispatchToProps = {
    chooseAccount,
    primaryActionTriggered,
    setPopupSize,
    authPrepareWithCred
};

const connectedQrSecureAuth = connect(mapStateToProps, mapDispatchToProps)(withResize(QrSecureAuth));

export {connectedQrSecureAuth as QrSecureAuth};
