import {combineReducers} from 'redux';
import am from '@blocks/authv2/reducers/am';
import common from '@blocks/common/reducers';
import {
    AUTH_PREPARE_WITH_CRED_SUCCESS,
    AUTH_PREPARE_WITH_CRED_FAIL,
    START_LOADING_PREPARE_WITH_CRED,
    SHOW_SUCCESS_SCREEN
} from './actions/';

const stub = (state = {}) => state;

const initialState = {
    browser: '',
    osFamily: '',
    regionName: '',
    deviceName: '',
    isAuthPrepareWithCredError: false,
    isLoading: false,
    error: null,
    errorText: '',
    isShowSuccessScreen: false,
    isTrackError: false
};

const rootReducer = combineReducers({
    am,
    common,
    customs: stub,
    person: stub,
    access: stub,
    settings: stub,
    footer: stub,
    metrics: stub,
    monitoring: stub,
    tracks: stub,
    auth: stub,
    qrSecureAuth
});

export default rootReducer;

export function qrSecureAuth(state = initialState, action = {}) {
    switch (action.type) {
        case START_LOADING_PREPARE_WITH_CRED: {
            return {
                ...state,
                isLoading: true
            };
        }
        case AUTH_PREPARE_WITH_CRED_SUCCESS: {
            return {
                ...state,
                isLoading: false
            };
        }
        case AUTH_PREPARE_WITH_CRED_FAIL: {
            return {
                ...state,
                isLoading: false,
                isAuthPrepareWithCredError: true,
                error: action.payload.error,
                errorText: action.payload.error[0] || ''
            };
        }
        case SHOW_SUCCESS_SCREEN: {
            return {
                ...state,
                isShowSuccessScreen: true
            };
        }
        default:
            return state;
    }
}
