import React from 'react';
import PropTypes from 'prop-types';
import {Button} from '@components/Button';
import {Icon} from '@components/IconLego';
import {cn} from '@bem-react/classname';
import './ResizeTestPush.styl';

const b = cn('ResizeTestPush');

const OPTIONS = {
    fullscreen: {
        mode: 'fullscreen',
        cornerRadius: 0,
        horizontalMargins: 0,
        verticalMargins: 0,
        height: 0
    },
    bottom: {
        mode: 'bottom',
        cornerRadius: 20,
        horizontalMargins: 16,
        verticalMargins: 16,
        height: 300
    },
    top: {
        mode: 'top',
        cornerRadius: 20,
        horizontalMargins: 16,
        verticalMargins: 16,
        height: 600
    },
    center: {
        mode: 'center',
        cornerRadius: 20,
        horizontalMargins: 16,
        verticalMargins: 16,
        height: 150
    }
};
const OPTIONS_MODES = ['fullscreen', 'bottom', 'top', 'center'];

class ResizeTestPush extends React.PureComponent {
    _closePopup = () => {
        const {finishCancelUrl} = this.props;

        window.location.href = finishCancelUrl;
    };

    _onSetSize = (event) => {
        const {setPopupSize} = this.props;
        const {mode} = event.currentTarget.dataset;

        setPopupSize(OPTIONS[mode]);
    };

    _renderButtons = () =>
        OPTIONS_MODES.map((mode) => (
            <div key={mode} className={b('Button')}>
                <Button type='button' data-mode={mode} view='action' size='s' width='auto' onClick={this._onSetSize}>
                    {mode}
                </Button>
            </div>
        ));

    render() {
        return (
            <div className={b('wrapper')}>
                <div className={b('content')}>
                    <button className={b('close')} onClick={this._closePopup}>
                        <Icon size='xs' glyph='type-cross-websearch' className={b('closeIcon')} />
                    </button>

                    {this._renderButtons()}
                </div>
            </div>
        );
    }
}

ResizeTestPush.propTypes = {
    setPopupSize: PropTypes.func.isRequired,
    finishCancelUrl: PropTypes.string.isRequired
};

export {ResizeTestPush};
